/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractNumberType;
import org.tentackle.sql.datatypes.ShortPrimitiveType;

@Service(value=DataType.class)
public sealed class ShortType
extends AbstractNumberType<Short>
permits ShortPrimitiveType {
    @Override
    public String getJavaType() {
        return "Short";
    }

    @Override
    public boolean isDowncastNecessary() {
        return true;
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("short"));
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.SMALLINT;
    }

    @Override
    public Short valueOf(String str) {
        return Short.valueOf(StringHelper.parseString((String)str));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Short object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 5);
        } else {
            statement.setShort(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Short get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return resultSet.getShort(pos[0]);
    }
}

