/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Optional;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public final class OffsetDateTimeType
extends AbstractDateTimeType<OffsetDateTime> {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[ ]xxx");
    private static final DateTimeFormatter MS_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS[ ]xxx");

    public static Timestamp timestampOf(OffsetDateTime value) {
        return Timestamp.valueOf(value.toLocalDateTime().minusSeconds(OffsetDateTimeType.offsetOf(value)));
    }

    public static int offsetOf(OffsetDateTime value) {
        return value.getOffset().getTotalSeconds();
    }

    @Override
    public String getJavaType() {
        return "OffsetDateTime";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public Object getMappedNullValue(Backend backend, int index) {
        return switch (index) {
            case 0 -> DateHelper.MIN_TIMESTAMP;
            case 1 -> Integer.valueOf(0);
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public int getColumnCount(Backend backend) {
        return 2;
    }

    @Override
    public Optional<String> getCommentSuffix(Backend backend, int index) {
        return switch (index) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of(" [+-s]");
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnGetter(int index, String varName) {
        return switch (index) {
            case 0 -> "OffsetDateTimeType.timestampOf(" + varName + ")";
            case 1 -> "OffsetDateTimeType.offsetOf(" + varName + ")";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnAlias(int index) {
        return switch (index) {
            case 0 -> "timestamp";
            case 1 -> "offset";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public Object getColumnValue(Backend backend, int index, OffsetDateTime value) {
        if (value != null) {
            int offset = OffsetDateTimeType.offsetOf(value);
            return switch (index) {
                case 0 -> Timestamp.valueOf(value.toLocalDateTime().minusSeconds(offset));
                case 1 -> offset;
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return null;
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        return switch (index) {
            case 0 -> super.getSize(backend, index, size);
            case 1 -> 0;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public int getScale(Backend backend, int index, Integer scale) {
        return 0;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        return switch (index) {
            case 0 -> SqlType.TIMESTAMP;
            case 1 -> SqlType.INTEGER;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public OffsetDateTime valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(OffsetDateTime object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public String toLiteral(String str, Integer index) {
        if (index != null && index == 0 && !((String)str).isEmpty() && ((String)str).charAt(0) != '\'') {
            str = "'" + (String)str + "'";
        }
        return str;
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (index != null) {
            return switch (index) {
                case 0 -> {
                    if ("null".equals(str)) {
                        yield str;
                    }
                    if (!((String)str).isEmpty() && Character.isDigit(((String)str).charAt(0))) {
                        str = "\"" + (String)str + "\"";
                    }
                    yield "Timestamp.valueOf(" + (String)str + ")";
                }
                case 1 -> str;
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        if (!((String)str).isEmpty() && Character.isDigit(((String)str).charAt(0))) {
            str = "\"" + (String)str + "\"";
        }
        return "OffsetDateTime.parse(" + (String)str + ")";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, OffsetDateTime object, boolean mapNull, Integer size) throws SQLException {
        void var7_9;
        int offset;
        if (object == null) {
            if (!mapNull) {
                statement.setNull(pos, 93);
                statement.setNull(pos + 1, 4);
                return new Object[]{null, null};
            }
            org.tentackle.common.Timestamp timestamp = DateHelper.MIN_TIMESTAMP;
            offset = 0;
        } else {
            offset = OffsetDateTimeType.offsetOf(object);
            Timestamp timestamp = Timestamp.valueOf(object.toLocalDateTime().minusSeconds(offset));
        }
        statement.setTimestamp(pos, (Timestamp)var7_9);
        statement.setInt(pos + 1, offset);
        return new Object[]{var7_9, offset};
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, OffsetDateTime object, int index, boolean mapNull, Integer size) throws SQLException {
        switch (index) {
            case 0: {
                Timestamp timestamp;
                if (object == null) {
                    if (!mapNull) {
                        statement.setNull(pos, 93);
                        return null;
                    }
                    timestamp = DateHelper.MIN_TIMESTAMP;
                } else {
                    timestamp = OffsetDateTimeType.timestampOf(object);
                }
                statement.setTimestamp(pos, timestamp);
                Comparable<Date> comparable = timestamp;
                return comparable;
            }
            case 1: {
                int offset;
                if (object == null) {
                    if (!mapNull) {
                        statement.setNull(pos, 4);
                        return null;
                    }
                    offset = 0;
                } else {
                    offset = OffsetDateTimeType.offsetOf(object);
                }
                statement.setInt(pos, offset);
                Comparable<Date> comparable = offset;
                return comparable;
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public OffsetDateTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(pos[0]);
        int offset = resultSet.getInt(pos[1]);
        if (resultSet.wasNull() || mapNull && timestamp.getTime() == 0L && offset == 0) {
            return null;
        }
        return OffsetDateTime.of(timestamp.toLocalDateTime().plusSeconds(offset), ZoneOffset.ofTotalSeconds(offset));
    }

    public OffsetDateTime parse(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).contains(".")) {
            try {
                return MS_TIMESTAMP_FORMATTER.parse((CharSequence)str, OffsetDateTime::from);
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing timestamp with ms from '" + str + "' failed", e);
            }
        }
        try {
            return TIMESTAMP_FORMATTER.parse((CharSequence)str, OffsetDateTime::from);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing timestamp from '" + str + "' failed", e);
        }
    }

    public String format(OffsetDateTime dateTime) {
        int nanos = dateTime.getNano();
        if (nanos != 0) {
            return MS_TIMESTAMP_FORMATTER.format(dateTime);
        }
        return TIMESTAMP_FORMATTER.format(dateTime);
    }
}

