/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public final class LocalDateType
extends AbstractDateTimeType<LocalDate> {
    @Override
    public String getJavaType() {
        return "LocalDate";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.DATE;
    }

    @Override
    public LocalDate valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(LocalDate object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, LocalDate object, boolean mapNull, Integer size) throws SQLException {
        Date value;
        if (object == null) {
            if (!mapNull) {
                statement.setNull(pos, 91);
                return new Object[]{null};
            }
            value = DateHelper.MIN_DATE;
        } else {
            value = Date.valueOf(object);
        }
        statement.setDate(pos, value);
        return new Object[]{value};
    }

    @Override
    public LocalDate get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Date date = resultSet.getDate(pos[0]);
        if (date == null || mapNull && date.equals(DateHelper.MIN_DATE)) {
            return null;
        }
        return date.toLocalDate();
    }

    public LocalDate parse(String str) throws BackendException {
        try {
            return LocalDate.parse(StringHelper.parseString((String)str), DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing date from '" + str + "' failed", e);
        }
    }

    public String format(LocalDate date) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }
}

