/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractNumberType;
import org.tentackle.sql.datatypes.FloatPrimitiveType;

@Service(value=DataType.class)
public sealed class FloatType
extends AbstractNumberType<Float>
permits FloatPrimitiveType {
    @Override
    public String getJavaType() {
        return "Float";
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("float"));
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.FLOAT;
    }

    @Override
    public Float valueOf(String str) {
        return Float.valueOf(StringHelper.parseString((String)str));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Float object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 6);
        } else {
            statement.setFloat(pos, object.floatValue());
        }
        return new Object[]{object};
    }

    @Override
    public Float get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return Float.valueOf(resultSet.getFloat(pos[0]));
    }
}

