/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlNameType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.backends.AbstractSql2003Backend;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.OracleColumnMetaData;
import org.tentackle.sql.metadata.TableMetaData;

@Service(value=Backend.class)
public class Oracle8
extends AbstractSql2003Backend {
    public static final String SQL_NESTED_SELECT_1 = "/*+ FIRST_ROWS */ * FROM (SELECT ";
    public static final String SQL_NESTED_SELECT_2 = ") WHERE ";
    public static final String SQL_NESTED_SELECT_ROWNUM = "ROWNUM";
    public static final String SQL_NESTED_SELECT_LIMIT = "ROWNUM<=?";
    public static final String SQL_NESTED_SELECT_OFFSET = "ROWNUM>?";
    private static final String ORA_DATE_FORMAT = "YYYY-MM-DD";
    private static final String ORA_TIME_FORMAT = "HH24:MI:SS";
    private static final String ORA_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String ORA_TO_DATE_LEAD = "TO_DATE('";
    private static final String ORA_TO_DATE_SEP = "','";
    private static final String ORA_TO_DATE_TAIL = "')";
    private static final String JAVA_DATE_FORMAT = "yyyy-MM-dd";
    private static final String JAVA_TIME_FORMAT = "HH:mm:ss";
    private static final String JAVA_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String ORACLE_EMPTY_STRING = " ";
    private static final int MAX_NAME_LENGTH = 30;
    private static final String[] RESERVED_SCHEMAS = new String[]{"ANONYMOUS", "APEX_030200", "APEX_PUBLIC_USER", "APPQOSSYS", "BI", "CTXSYS", "DBSNMP", "DIP", "EXFSYS", "FLOWS_FILES", "HR", "IX", "MDDATA", "MDSYS", "MGMT_VIEW", "OE", "OLAPSYS", "ORACLE_OCM", "ORDDATA", "ORDPLUGINS", "ORDSYS", "OUTLN", "OWBSYS", "OWBSYS_AUDIT", "PM", "SCOTT", "SH", "SI_INFORMTN_SCHEMA", "SPATIAL_CSW_ADMIN_USR", "SPATIAL_WFS_ADMIN_USR", "SYS", "SYSMAN", "SYSTEM", "WMSYS", "XDB", "XS$NULL"};

    public static String dateString(Date date) {
        return ORA_TO_DATE_LEAD + DATE_FORMAT.format(date.toLocalDate()) + "','YYYY-MM-DD')";
    }

    public static String timeString(Time time) {
        return ORA_TO_DATE_LEAD + TIME_FORMAT.format(time.toLocalTime()) + "','HH24:MI:SS')";
    }

    public static String timestampString(Timestamp timestamp) {
        return ORA_TO_DATE_LEAD + TIMESTAMP_FORMAT.format(timestamp.toLocalDateTime()) + "','YYYY-MM-DD HH24:MI:SS')";
    }

    @Override
    public boolean isDeprecated() {
        return true;
    }

    @Override
    public String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public Connection createConnection(String url, String username, char[] password) throws SQLException {
        Properties props = new Properties();
        props.put("user", username);
        if (password != null) {
            props.put("password", this.createPassword(password));
        }
        props.put("remarksReporting", "true");
        try {
            Class.forName(this.getDriverClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return DriverManager.getConnection(url, props);
    }

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":oracle:");
    }

    @Override
    public String getName() {
        return "Oracle8";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("select sys_context('userenv','sid') from dual");
            if (rs.next()) {
                String string2 = "SID-" + rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new BackendException("cannot determine backend id", ex);
        }
    }

    @Override
    public boolean isSchemaSupported() {
        return false;
    }

    @Override
    public boolean isTemporaryName(String name) {
        return name != null && (name.startsWith("tmp_") || name.startsWith("TMP_"));
    }

    @Override
    public boolean isReservedTableName(String name) {
        return super.isReservedTableName(name) || name != null && name.contains("$");
    }

    @Override
    public boolean isReservedSchemaName(String name) {
        for (String reserved_schema : RESERVED_SCHEMAS) {
            if (!reserved_schema.equalsIgnoreCase(name)) continue;
            return true;
        }
        return super.isReservedSchemaName(name);
    }

    @Override
    public void assertValidName(SqlNameType nameType, String name) {
        super.assertValidName(nameType, name);
        this.assertNameLength(nameType, name);
        if (name != null && name.startsWith("_")) {
            throw new BackendException(String.valueOf((Object)nameType) + " '" + name + "' is illegal for backend " + String.valueOf(this));
        }
    }

    @Override
    public boolean isTransientTransactionException(SQLException ex) {
        return super.isTransientTransactionException(ex) || this.isExceptionErrorCodeMatching(ex, 54, 60, 1013, 4020, 4021, 30006);
    }

    @Override
    public String getEmptyString() {
        return ORACLE_EMPTY_STRING;
    }

    @Override
    public String columnTypeNullDefaultToString(String columnName, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.columnTypeToString(sqlType, size, scale));
        if (defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        if (!nullable) {
            buf.append(" NOT NULL");
        }
        return buf.toString();
    }

    @Override
    public String valueToLiteral(SqlType sqlType, Object value) {
        if (value instanceof String && ((String)value).isEmpty()) {
            value = ORACLE_EMPTY_STRING;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? "1" : "0";
        }
        return super.valueToLiteral(sqlType, value);
    }

    @Override
    public ColumnMetaData createColumnMetaData(TableMetaData tableMetaData) {
        return new OracleColumnMetaData(tableMetaData);
    }

    @Override
    public boolean isExtraCommitRequired() {
        return true;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        boolean insertSelect = this.isLeadingSelectMissing(sqlBuilder);
        if (limit > 0 || offset > 0) {
            sqlBuilder.insert(0, SQL_NESTED_SELECT_1);
        }
        if (insertSelect) {
            sqlBuilder.insert(0, "SELECT ");
        }
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (limit > 0 || offset > 0) {
            sqlBuilder.append(SQL_NESTED_SELECT_2);
            if (offset > 0) {
                sqlBuilder.append(SQL_NESTED_SELECT_OFFSET);
            }
            if (limit > 0) {
                if (offset > 0) {
                    sqlBuilder.append(" AND ");
                }
                sqlBuilder.append(SQL_NESTED_SELECT_LIMIT);
            }
        }
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        return switch (sqlType) {
            case SqlType.DECIMAL -> 37;
            case SqlType.VARCHAR -> 4000;
            default -> super.getMaxSize(sqlType);
        };
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        return switch (sqlType) {
            case SqlType.BIT, SqlType.TINYINT -> "NUMBER(1)";
            case SqlType.SMALLINT -> "NUMBER(5)";
            case SqlType.INTEGER -> "NUMBER(10)";
            case SqlType.BIGINT -> "NUMBER(19)";
            case SqlType.FLOAT -> "REAL";
            case SqlType.DOUBLE -> "DOUBLE";
            case SqlType.DECIMAL -> "NUMBER";
            case SqlType.CHAR -> "CHAR(1)";
            case SqlType.VARCHAR -> "VARCHAR";
            case SqlType.DATE, SqlType.TIME -> "DATE";
            case SqlType.TIMESTAMP -> "TIMESTAMP";
            case SqlType.BLOB -> "BLOB";
            case SqlType.CLOB -> "CLOB";
            default -> super.sqlTypeToString(sqlType, size);
        };
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT};
            }
            case 2: 
            case 3: {
                if (scale == 0) {
                    switch (size) {
                        case 1: {
                            return new SqlType[]{SqlType.BIT, SqlType.TINYINT};
                        }
                        case 5: {
                            return new SqlType[]{SqlType.SMALLINT};
                        }
                        case 10: {
                            return new SqlType[]{SqlType.INTEGER};
                        }
                        case 19: {
                            return new SqlType[]{SqlType.BIGINT};
                        }
                    }
                }
                return new SqlType[]{SqlType.DECIMAL};
            }
            case 91: 
            case 92: {
                return new SqlType[]{SqlType.DATE, SqlType.TIME};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlNextFromSequence(String name) {
        return "SELECT " + name + ".NEXTVAL FROM DUAL";
    }

    @Override
    public String sqlRenameTable(String tableName, String newTableName) {
        return "RENAME TABLE " + tableName + " TO " + newTableName + ";\n";
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnNullConstraint(String tableName, String columnName, boolean nullable) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" MODIFY (");
        buf.append(columnName);
        if (nullable) {
            buf.append(" NULL");
        } else {
            buf.append(" NOT NULL");
        }
        buf.append(");\n");
        return buf.toString();
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " MODIFY (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, true, null, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnDefault(String tableName, String columnName, SqlType sqlType, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" MODIFY ");
        buf.append(columnName);
        if (defaultValue == null) {
            buf.append(" DEFAULT NULL");
        } else {
            buf.append(" DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        buf.append(";\n");
        return buf.toString();
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = (sql = super.extractWhereClause(sql, whereOffset)).lastIndexOf(SQL_NESTED_SELECT_ROWNUM, whereOffset);
        if (ndx >= 0) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }

    private void assertNameLength(SqlNameType nameType, String name) {
        if (name != null && name.length() > 30) {
            throw new BackendException(String.valueOf((Object)nameType) + " name " + name + " is too long (" + name.length() + "). " + String.valueOf(this) + " allows only 30");
        }
    }
}

