/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.backends.Oracle8;

@Service(value=Backend.class)
public class Oracle
extends Oracle8 {
    private static final String SQL_FETCHNEXT_1 = " FETCH NEXT ";
    private static final String SQL_FETCHNEXT_2 = " ROWS ONLY";
    private static final String SQL_FETCHNEXT_PAR = " FETCH NEXT ? ROWS ONLY";
    private static final String SQL_OFFSET_1 = " OFFSET ";
    private static final String SQL_OFFSET_2 = " ROWS";
    private static final String SQL_OFFSET_PAR = " OFFSET ? ROWS";

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public void validateVersion(int databaseMajorVersion, int databaseMinorVersion) {
        if (databaseMajorVersion < 12) {
            throw new BackendException(String.valueOf(this) + " needs at least Oracle 12, but is connected to " + databaseMajorVersion + "." + databaseMinorVersion + " (consider adding '|Oracle8' to the connection URL)");
        }
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (this.isLeadingSelectMissing(sqlBuilder)) {
            sqlBuilder.insert(0, "SELECT ");
        }
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (offset > 0) {
            sqlBuilder.append(SQL_OFFSET_PAR);
        }
        if (limit > 0) {
            sqlBuilder.append(SQL_FETCHNEXT_PAR);
        }
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = (sql = super.extractWhereClause(sql, whereOffset)).lastIndexOf(SQL_OFFSET_1);
        if (ndx >= 0) {
            sql = sql.substring(0, ndx);
        }
        if ((ndx = sql.lastIndexOf(SQL_FETCHNEXT_1)) >= 0) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }
}

