/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.backends.AbstractSql2003Backend;

@Service(value=Backend.class)
public class MsSql
extends AbstractSql2003Backend {
    public static final String SQL_TOP = "TOP ";
    public static final String SQL_TOP_PAR = "TOP ? ";

    @Override
    public boolean isFilteredIndexSupported() {
        return true;
    }

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":sqlserver");
    }

    @Override
    public String getName() {
        return "MsSQL";
    }

    @Override
    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT @@SPID");
            if (rs.next()) {
                String string2 = "ID-" + rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new BackendException("cannot determine backend id", ex);
        }
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (limit > 0 && offset <= 0) {
            boolean insertSelect = this.isLeadingSelectMissing(sqlBuilder);
            sqlBuilder.insert(0, SQL_TOP_PAR);
            if (insertSelect) {
                sqlBuilder.insert(0, "SELECT ");
            }
        } else {
            super.buildSelectSql(sqlBuilder, writeLock, limit, offset);
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        int index = 1;
        if (limit > 0 && offset <= 0) {
            stmt.setInt(index++, limit);
        }
        return index;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (limit > 0 && offset <= 0) {
            return index;
        }
        return super.setTrailingSelectParameters(stmt, index, limit, offset);
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        if (sqlType == SqlType.DECIMAL) {
            return 38;
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        return switch (sqlType) {
            case SqlType.BIT -> "BIT";
            case SqlType.TINYINT -> "TINYINT";
            case SqlType.SMALLINT -> "SMALLINT";
            case SqlType.INTEGER -> "INT";
            case SqlType.BIGINT -> "BIGINT";
            case SqlType.FLOAT -> "REAL";
            case SqlType.DOUBLE -> "FLOAT";
            case SqlType.DECIMAL -> "DECIMAL";
            case SqlType.CHAR -> "NCHAR(1)";
            case SqlType.VARCHAR -> {
                if (size == 0) {
                    yield "NVARCHAR(MAX)";
                }
                yield "NVARCHAR";
            }
            case SqlType.DATE, SqlType.TIME, SqlType.TIMESTAMP -> "DATETIME";
            case SqlType.BLOB -> "VARBINARY(MAX)";
            case SqlType.CLOB -> "CLOB";
            default -> super.sqlTypeToString(sqlType, size);
        };
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        SqlType[] sqlTypeArray;
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                SqlType[] sqlTypeArray2 = new SqlType[3];
                sqlTypeArray2[0] = SqlType.BIT;
                sqlTypeArray2[1] = SqlType.TINYINT;
                sqlTypeArray = sqlTypeArray2;
                sqlTypeArray2[2] = SqlType.SMALLINT;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                SqlType[] sqlTypeArray3 = new SqlType[3];
                sqlTypeArray3[0] = SqlType.DATE;
                sqlTypeArray3[1] = SqlType.TIME;
                sqlTypeArray = sqlTypeArray3;
                sqlTypeArray3[2] = SqlType.TIMESTAMP;
                break;
            }
            default: {
                sqlTypeArray = super.jdbcTypeToSqlType(jdbcType, size, scale);
            }
        }
        return sqlTypeArray;
    }

    @Override
    public String sqlRenameIndex(String tableName, String oldIndexName, String newIndexName) {
        return null;
    }

    @Override
    public boolean isTransientTransactionException(SQLException ex) {
        return super.isTransientTransactionException(ex) || this.isExceptionErrorCodeMatching(ex, 1222) || this.isExceptionStateMatching(ex, "HY008");
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = sql.indexOf(SQL_TOP);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with TOP");
        }
        return super.extractWhereClause(sql, whereOffset);
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }
}

