/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.MigrationStrategy;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.backends.AbstractSql92Backend;
import org.tentackle.sql.metadata.ColumnMetaData;

@Service(value=Backend.class)
public class H2
extends AbstractSql92Backend {
    public static final String DEFAULT_SCHEMA = "public";
    public static final String SQL_FETCH_FIRST = " FETCH FIRST ";
    public static final String SQL_OFFSET = " OFFSET ";
    public static final String SQL_FETCH_FIRST_PAR = " FETCH FIRST ? ROWS ONLY";
    public static final String SQL_OFFSET_PAR = " OFFSET ? ROWS";
    public static final String[] RESERVED_WORDS_H2 = new String[]{"UUID"};
    private static final String[] RESERVED_SCHEMAS = new String[]{"information_schema"};
    private static Set<String> reservedWords;

    @Override
    public synchronized Set<String> getReservedWords() {
        if (reservedWords == null) {
            reservedWords = new HashSet<String>(super.getReservedWords());
            reservedWords.addAll(Arrays.asList(RESERVED_WORDS_H2));
        }
        return reservedWords;
    }

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":h2:");
    }

    @Override
    public String getName() {
        return "H2";
    }

    @Override
    public String getDriverClassName() {
        return "org.h2.Driver";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("select SESSION_ID()");
            if (rs.next()) {
                String string2 = "ID-" + rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new BackendException("cannot determine backend id", ex);
        }
    }

    @Override
    public boolean isReleaseSavepointSupported() {
        return true;
    }

    @Override
    public boolean isReservedSchemaName(String name) {
        for (String reserved_schema : RESERVED_SCHEMAS) {
            if (!reserved_schema.equalsIgnoreCase(name)) continue;
            return true;
        }
        return super.isReservedSchemaName(name);
    }

    @Override
    public boolean isTransientTransactionException(SQLException ex) {
        return super.isTransientTransactionException(ex) || this.isExceptionStateMatching(ex, "40001", "50200", "90131");
    }

    @Override
    public boolean isUUIDSupported() {
        return true;
    }

    @Override
    public boolean isAliasRequiredForSubSelect() {
        return true;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (this.isLeadingSelectMissing(sqlBuilder)) {
            sqlBuilder.insert(0, "SELECT ");
        }
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (limit > 0) {
            sqlBuilder.append(SQL_FETCH_FIRST_PAR);
        }
        if (offset > 0) {
            sqlBuilder.append(SQL_OFFSET_PAR);
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        return 1;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (limit > 0) {
            stmt.setInt(index++, limit);
        }
        if (offset > 0) {
            stmt.setInt(index++, offset);
        }
        return index;
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        return switch (sqlType) {
            case SqlType.DECIMAL -> 99999;
            case SqlType.VARCHAR -> 0x100000;
            default -> super.getMaxSize(sqlType);
        };
    }

    @Override
    public String getDefaultSchema() {
        return DEFAULT_SCHEMA;
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        SqlType[] sqlTypeArray;
        switch (jdbcType) {
            case -6: 
            case 5: {
                SqlType[] sqlTypeArray2 = new SqlType[2];
                sqlTypeArray2[0] = SqlType.TINYINT;
                sqlTypeArray = sqlTypeArray2;
                sqlTypeArray2[1] = SqlType.SMALLINT;
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                SqlType[] sqlTypeArray3 = new SqlType[2];
                sqlTypeArray3[0] = SqlType.VARCHAR;
                sqlTypeArray = sqlTypeArray3;
                sqlTypeArray3[1] = SqlType.CLOB;
                break;
            }
            case 1111: {
                SqlType[] sqlTypeArray4 = new SqlType[1];
                sqlTypeArray = sqlTypeArray4;
                sqlTypeArray4[0] = SqlType.UUID;
                break;
            }
            default: {
                sqlTypeArray = super.jdbcTypeToSqlType(jdbcType, size, scale);
            }
        }
        return sqlTypeArray;
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        return switch (sqlType) {
            case SqlType.BIT -> "BOOLEAN";
            case SqlType.TINYINT -> "TINYINT";
            case SqlType.SMALLINT -> "SMALLINT";
            case SqlType.INTEGER -> "INTEGER";
            case SqlType.BIGINT -> "BIGINT";
            case SqlType.FLOAT -> "REAL";
            case SqlType.DOUBLE -> "DOUBLE PRECISION";
            case SqlType.DECIMAL -> "DECIMAL";
            case SqlType.CHAR -> "CHAR(1)";
            case SqlType.VARCHAR -> "VARCHAR";
            case SqlType.DATE -> "DATE";
            case SqlType.TIME -> "TIME";
            case SqlType.TIMESTAMP -> "TIMESTAMP";
            case SqlType.BLOB -> "BLOB";
            case SqlType.CLOB -> "CLOB";
            case SqlType.UUID -> "UUID";
            default -> super.sqlTypeToString(sqlType, size);
        };
    }

    @Override
    public boolean isSequenceSupported() {
        return true;
    }

    @Override
    public String sqlNextFromSequence(String name) {
        return "SELECT NEXTVAL('" + name + "')";
    }

    @Override
    public String sqlCreateSequence(String name, Long start, Long increment) {
        return NonStandardCommons.sqlCreateSequence(name, start, increment);
    }

    @Override
    public String sqlCreateSequenceComment(String name, String comment) {
        return NonStandardCommons.sqlCreateCommentOnSequence(this, name, comment);
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " TYPE " + this.columnTypeNullDefaultToString(columnName, sqlType, size, scale, true, null) + ";\n";
    }

    @Override
    public String sqlAlterColumnNullConstraint(String tableName, String columnName, boolean nullable) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ALTER COLUMN ");
        buf.append(columnName);
        if (nullable) {
            buf.append(" DROP");
        } else {
            buf.append(" SET");
        }
        buf.append(" NOT NULL;\n");
        return buf.toString();
    }

    @Override
    public boolean isArrayOperatorSupported(String operator) {
        return "ALL".equals(operator) || "ANY".equals(operator);
    }

    @Override
    public MigrationStrategy[] getMigrationStrategy(ColumnMetaData column, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        boolean scaleWarning;
        ArrayList<MigrationStrategy> strategies = new ArrayList<MigrationStrategy>();
        int maxSize = this.getMaxSize(sqlType);
        boolean nameChanged = !column.getColumnName().equalsIgnoreCase(columnName);
        boolean commentChanged = !Objects.equals(column.getComment(), comment);
        boolean defaultChanged = !this.isDefaultEqual(column, sqlType, defaultValue);
        boolean nullChanged = column.isNullable() != nullable;
        boolean typeChanged = !column.matchesSqlType(sqlType);
        boolean sizeChanged = maxSize != -1 && (size > column.getSize() || size == 0 && (sqlType == SqlType.VARCHAR || sqlType == SqlType.CLOB) && column.getSize() > 0 && column.getSize() != Integer.MAX_VALUE);
        boolean sizeWarning = maxSize != -1 && size != 0 && size < column.getSize();
        boolean scaleChanged = scale > column.getScale();
        boolean bl = scaleWarning = maxSize != -1 && scale < column.getScale();
        if (nameChanged) {
            strategies.add(MigrationStrategy.NAME);
        }
        if (typeChanged || sizeChanged || scaleChanged) {
            strategies.add(MigrationStrategy.TYPE);
        } else if (sizeWarning || scaleWarning) {
            strategies.add(MigrationStrategy.TYPE_WARNING);
        }
        if (nullChanged) {
            strategies.add(MigrationStrategy.NULL);
        }
        if (defaultChanged) {
            strategies.add(MigrationStrategy.DEFAULT);
        }
        if (commentChanged) {
            strategies.add(MigrationStrategy.COMMENT);
        }
        return strategies.toArray(new MigrationStrategy[0]);
    }

    @Override
    public boolean isDatabaseInMemory(String url) {
        return this.isMatchingUrl(url) && url.contains(":mem:");
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = (sql = super.extractWhereClause(sql, whereOffset)).lastIndexOf(SQL_FETCH_FIRST);
        if (ndx >= 0) {
            sql = sql.substring(0, ndx);
        }
        if ((ndx = sql.lastIndexOf(SQL_OFFSET)) >= 0) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }
}

