/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import java.util.function.Function;
import org.tentackle.common.Binary;
import org.tentackle.sql.datatypes.UUIDType;

public enum SqlType {
    VARCHAR(String.class, "", SqlType::removeSingleQuotes),
    DATE(Date.class, new Date(0L), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Date.valueOf(t);
        }
        catch (RuntimeException rex) {
            return new Date(0L);
        }
    }),
    TIME(Time.class, new Time(0L), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Time.valueOf(t);
        }
        catch (RuntimeException rex) {
            return new Time(0L);
        }
    }),
    TIMESTAMP(Timestamp.class, new Timestamp(0L), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Timestamp.valueOf(t);
        }
        catch (RuntimeException rex) {
            return new Timestamp(0L);
        }
    }),
    BLOB(Binary.class, null, t -> null),
    CLOB(String.class, "", SqlType::removeSingleQuotes),
    DECIMAL(BigDecimal.class, new BigDecimal(0), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return BigDecimal.valueOf(Double.parseDouble(t));
        }
        catch (RuntimeException rex) {
            return new BigDecimal(0);
        }
    }),
    CHAR(Character.class, Character.valueOf(' '), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Character.valueOf(t.isEmpty() ? (char)' ' : t.charAt(0));
        }
        catch (RuntimeException rex) {
            return Character.valueOf(' ');
        }
    }),
    BIT(Boolean.class, false, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Boolean.valueOf(t);
        }
        catch (RuntimeException rex) {
            return false;
        }
    }),
    TINYINT(Byte.class, (byte)0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Byte.valueOf(t);
        }
        catch (RuntimeException rex) {
            return (byte)0;
        }
    }),
    SMALLINT(Short.class, (short)0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Short.valueOf(t);
        }
        catch (RuntimeException rex) {
            return (short)0;
        }
    }),
    INTEGER(Integer.class, 0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Integer.valueOf(t);
        }
        catch (RuntimeException rex) {
            return 0;
        }
    }),
    BIGINT(Long.class, 0L, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Long.valueOf(t);
        }
        catch (RuntimeException rex) {
            return 0L;
        }
    }),
    FLOAT(Float.class, Float.valueOf(0.0f), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Float.valueOf(t);
        }
        catch (RuntimeException rex) {
            return Float.valueOf(0.0f);
        }
    }),
    DOUBLE(Double.class, 0.0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Double.valueOf(t);
        }
        catch (RuntimeException rex) {
            return 0.0;
        }
    }),
    UUID(UUID.class, UUIDType.NIL, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return java.util.UUID.fromString(t);
        }
        catch (RuntimeException rex) {
            return UUIDType.NIL;
        }
    }),
    JAVA_OBJECT(Object.class, null, t -> null);

    private final Class<?> clazz;
    private final Object defaultValue;
    private final Function<String, Object> parser;

    private static String removeSingleQuotes(String str) {
        if (str != null && str.length() >= 2 && str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private SqlType(Class<?> clazz, Object defaultValue, Function<String, Object> parser) {
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.parser = parser;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object parse(String str) {
        return this.parser.apply(str);
    }
}

