/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.tentackle.sql.BackendException;

public class DynamicDriver
implements Driver {
    private final Driver driver;

    public static Driver load(String name) {
        int ndx = name.indexOf(58);
        if (ndx > 0) {
            try {
                String classname = name.substring(0, ndx);
                URL url = new URI(name.substring(ndx + 1)).toURL();
                URLClassLoader ucl = new URLClassLoader(new URL[]{url});
                DynamicDriver driver = new DynamicDriver((Driver)Class.forName(classname, true, ucl).getConstructor(new Class[0]).newInstance(new Object[0]));
                DriverManager.registerDriver(driver);
                return driver;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | MalformedURLException | URISyntaxException | SQLException ex) {
                throw new BackendException("loading driver '" + name + "' failed", ex);
            }
        }
        throw new BackendException("malformed jdbc driver name: " + name);
    }

    public static void unload(Driver driver) {
        if (driver instanceof DynamicDriver) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                throw new BackendException("unloading JDBC driver failed", e);
            }
        } else {
            throw new BackendException("driver not loaded via DynamicDriver.load");
        }
    }

    private DynamicDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.driver.connect(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.driver.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.driver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driver.getParentLogger();
    }
}

