/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.ScriptRunner;
import org.tentackle.sql.ScriptRunnerResult;

public class DefaultScriptRunner
implements ScriptRunner {
    private final Backend backend;
    private final Connection connection;
    private final boolean posixEscapeSyntaxSupported;
    private boolean escapeProcessing = true;

    public DefaultScriptRunner(Backend backend, Connection connection) {
        this.backend = backend;
        this.connection = connection;
        this.posixEscapeSyntaxSupported = this.determinePosixEscapeSyntaxSupported();
    }

    @Override
    public Backend getBackend() {
        return this.backend;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setEscapeProcessingEnabled(boolean enabled) {
        this.escapeProcessing = enabled;
    }

    @Override
    public boolean isEscapeProcessingEnabled() {
        return this.escapeProcessing;
    }

    @Override
    public List<ScriptRunnerResult> run(String script) {
        ArrayList<ScriptRunnerResult> arrayList;
        block17: {
            SQLCode sqlCode = null;
            int offset = 0;
            Statement statement = this.connection.createStatement();
            try {
                statement.setEscapeProcessing(this.escapeProcessing);
                ArrayList<ScriptRunnerResult> scriptRunnerResults = new ArrayList<ScriptRunnerResult>();
                while ((sqlCode = this.determineNextSqlCode(script, offset)) != null) {
                    if (!sqlCode.sql.isBlank()) {
                        ArrayList<Object> resultList = new ArrayList<Object>();
                        int columnCount = 0;
                        if (statement.execute(sqlCode.sql)) {
                            ResultSet resultSet = statement.getResultSet();
                            while (true) {
                                if (resultSet.next()) {
                                    columnCount = this.extractResults(resultSet, resultList);
                                    continue;
                                }
                                if (!statement.getMoreResults()) break;
                            }
                            resultSet.close();
                        } else {
                            resultList.add(statement.getUpdateCount());
                        }
                        String statementWarnings = this.getWarnings(statement.getWarnings());
                        statement.clearWarnings();
                        scriptRunnerResults.add(new ScriptRunnerResult(sqlCode.sql, offset, statementWarnings, columnCount, resultList.toArray()));
                    }
                    if (sqlCode.nextOffset > offset) {
                        offset = sqlCode.nextOffset;
                        continue;
                    }
                    throw new BackendException("malformed SQL script");
                }
                String connectionWarnings = this.getWarnings(this.connection.getWarnings());
                this.connection.clearWarnings();
                if (!connectionWarnings.isEmpty()) {
                    scriptRunnerResults.add(new ScriptRunnerResult("", 0, connectionWarnings, 0, "Connection Warnings"));
                }
                arrayList = scriptRunnerResults;
                if (statement == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    if (sqlCode != null) {
                        throw new BackendException("script execution failed at offset " + offset + ": " + sqlCode.sql, ex);
                    }
                    throw new BackendException("script runner failed", ex);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    public SQLCode determineNextSqlCode(String script, int offset) {
        StringBuilder sql = new StringBuilder();
        boolean withinSingleQuotes = false;
        boolean withinDoubleQuotes = false;
        boolean withinPosixEscape = false;
        boolean withinBlockComment = false;
        while (offset < script.length()) {
            char c = script.charAt(offset);
            if (withinPosixEscape) {
                withinPosixEscape = false;
                if (!withinBlockComment) {
                    sql.append(c);
                }
            } else if (this.posixEscapeSyntaxSupported && c == '\\') {
                withinPosixEscape = true;
                if (!withinBlockComment) {
                    sql.append(c);
                }
            } else if (withinBlockComment) {
                boolean endFound = false;
                for (String blockEnd : this.backend.getBlockCommentEnds()) {
                    if (!script.startsWith(blockEnd, offset)) continue;
                    offset += blockEnd.length();
                    endFound = true;
                }
                if (endFound) {
                    withinBlockComment = false;
                    continue;
                }
            } else {
                if (!withinDoubleQuotes && c == '\'') {
                    withinSingleQuotes = !withinSingleQuotes;
                } else if (!withinSingleQuotes && c == '\"') {
                    boolean bl = withinDoubleQuotes = !withinDoubleQuotes;
                }
                if (!withinDoubleQuotes && !withinSingleQuotes) {
                    if (script.startsWith(this.backend.getStatementSeparator(), offset)) {
                        return new SQLCode(sql.toString(), offset + this.backend.getStatementSeparator().length());
                    }
                    String match = StringHelper.startsWithAnyOf((String)script, (int)offset, (String[])this.backend.getSingleLineComments());
                    if (match != null) {
                        int ndx = script.indexOf(10, offset += match.length());
                        if (ndx < offset) break;
                        offset = ndx - 1;
                    } else {
                        match = StringHelper.startsWithAnyOf((String)script, (int)offset, (String[])this.backend.getBlockCommentBegins());
                        if (match != null) {
                            withinBlockComment = true;
                            offset += match.length() - 1;
                        } else {
                            sql.append(c);
                        }
                    }
                } else {
                    sql.append(c);
                }
            }
            ++offset;
        }
        return sql.isEmpty() ? null : new SQLCode(sql.toString(), offset);
    }

    protected boolean determinePosixEscapeSyntaxSupported() {
        return this.backend.isPosixEscapeSyntaxSupported();
    }

    private int extractResults(ResultSet resultSet, List<Object> resultList) throws SQLException {
        int r;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (resultList.isEmpty()) {
            for (r = 1; r <= columnCount; ++r) {
                resultList.add(metaData.getColumnName(r));
            }
        }
        for (r = 1; r <= columnCount; ++r) {
            resultList.add(resultSet.getObject(r));
        }
        return columnCount;
    }

    private String getWarnings(SQLWarning warning) {
        StringBuilder warnings = new StringBuilder();
        while (warning != null) {
            if (!warnings.isEmpty()) {
                warnings.append('\n');
            }
            warnings.append(warning.getMessage());
            warning = warning.getNextWarning();
        }
        return warnings.toString();
    }

    public record SQLCode(String sql, int nextOffset) {
        public SQLCode(String sql, int nextOffset) {
            this.sql = sql = sql.stripLeading();
            this.nextOffset = nextOffset;
        }
    }
}

