/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

public class MetaDataHelper {
    private static Map<Integer, String> typeMap;

    public static synchronized String jdbcTypeToString(int jdbcType) {
        String str;
        if (typeMap == null) {
            typeMap = new HashMap<Integer, String>();
            for (Field field : Types.class.getDeclaredFields()) {
                if (field.getType() != Integer.TYPE || (field.getModifiers() & 8) == 0) continue;
                try {
                    typeMap.put((Integer)field.get(null), field.getName());
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
        if ((str = typeMap.get(jdbcType)) == null) {
            str = "UNKNOWN";
        }
        return str;
    }

    private MetaDataHelper() {
    }
}

