/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.util.ArrayList;
import java.util.Collection;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendFactory;

@Service(value=BackendFactory.class)
public class DefaultBackendFactory
implements BackendFactory {
    private final Collection<Backend> backends = new ArrayList<Backend>();

    public DefaultBackendFactory() {
        try {
            for (Class backendClass : ServiceFactory.getServiceFinder().findServiceProviders(Backend.class)) {
                this.backends.add((Backend)backendClass.newInstance());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException nfe) {
            throw new BackendException("supported backends could not be determined", nfe);
        }
    }

    @Override
    public Backend getBackendByUrl(String url) {
        for (Backend backend : this.backends) {
            if (!backend.isMatchingUrl(url)) continue;
            return backend;
        }
        throw new BackendException("no backend for jdbc-url=" + url);
    }

    @Override
    public Backend getBackendByName(String name) throws BackendException {
        for (Backend backend : this.backends) {
            if (!backend.isMatchingName(name)) continue;
            return backend;
        }
        throw new BackendException("no backend for name=" + name);
    }

    @Override
    public Collection<Backend> getAllBackends() throws BackendException {
        return this.backends;
    }
}

