/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.MetaDataHelper;
import org.tentackle.sql.metadata.TableMetaData;

public class ColumnMetaData {
    private static final String SUPPORTS_AUTOINCREMENT = "supportsAutoIncrement";
    private static final String SUPPORTS_GENERATED = "supportsGenerated";
    private final TableMetaData tableMetaData;
    private String columnName;
    private String comment;
    private int type;
    private String typeName;
    private int size;
    private int scale;
    private String defaultValue;
    private boolean nullable;
    private boolean generated;
    private boolean autoIncrement;

    public ColumnMetaData(TableMetaData tableMetaData) {
        this.tableMetaData = tableMetaData;
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public void setupColumnFromMetaData(ResultSet resultSet) throws SQLException {
        this.columnName = StringHelper.toLower((String)resultSet.getString("COLUMN_NAME"));
        this.comment = resultSet.getString("REMARKS");
        this.size = resultSet.getInt("COLUMN_SIZE");
        this.scale = resultSet.getShort("DECIMAL_DIGITS");
        this.nullable = resultSet.getInt("NULLABLE") == 1;
        this.type = resultSet.getInt("DATA_TYPE");
        this.typeName = resultSet.getString("TYPE_NAME");
        this.defaultValue = resultSet.getString("COLUMN_DEF");
        if (this.isSupported(SUPPORTS_GENERATED)) {
            try {
                this.autoIncrement = Objects.equals("YES", resultSet.getString("IS_AUTOINCREMENT"));
            }
            catch (SQLException sqx) {
                this.setSupported(SUPPORTS_GENERATED, false);
            }
        }
        if (this.isSupported(SUPPORTS_GENERATED)) {
            try {
                this.generated = Objects.equals("YES", resultSet.getString("IS_GENERATEDCOLUMN"));
            }
            catch (SQLException sqx) {
                this.setSupported(SUPPORTS_GENERATED, false);
            }
        }
        this.validate();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean matchesSqlType(SqlType sqlType) {
        SqlType[] possibleSqlTypes;
        Backend backend = this.tableMetaData.getModelMetaData().getBackend();
        for (SqlType possibleType : possibleSqlTypes = backend.jdbcTypeToSqlType(this.type, this.size, this.scale)) {
            if (sqlType != possibleType) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.columnName);
        buf.append(" ");
        buf.append(MetaDataHelper.jdbcTypeToString(this.type));
        if (this.size > 0) {
            buf.append("(");
            buf.append(this.size);
            if (this.scale > 0) {
                buf.append(",");
                buf.append(this.scale);
            }
            buf.append(")");
        }
        if (!this.nullable) {
            buf.append(" NOT NULL");
        }
        if (this.defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(this.defaultValue);
        }
        if (this.autoIncrement) {
            buf.append(" AUTOINCREMENT");
        }
        buf.append(" -- ");
        buf.append(this.typeName);
        if (this.generated) {
            buf.append(", GENERATED");
        }
        return buf.toString();
    }

    public void validate() {
        if (this.comment != null && this.comment.isEmpty()) {
            this.comment = null;
        }
        if (this.defaultValue != null && this.defaultValue.isEmpty()) {
            this.defaultValue = null;
        }
    }

    private boolean isSupported(String property) {
        String val = this.tableMetaData.getModelMetaData().getProperties().getProperty(property);
        return val == null ? true : Boolean.valueOf(val);
    }

    private void setSupported(String property, boolean supported) {
        this.tableMetaData.getModelMetaData().getProperties().setProperty(property, Boolean.toString(supported));
    }
}

