/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.function.Function;

public enum SqlType {
    VARCHAR(12, false, false, "", t -> SqlType.removeSingleQuotes(t)),
    DATE(91, false, false, new Date(0L), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Date.valueOf(t);
        }
        catch (RuntimeException rex) {
            return new Date(0L);
        }
    }),
    TIME(92, false, false, new Time(0L), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Time.valueOf(t);
        }
        catch (RuntimeException rex) {
            return new Time(0L);
        }
    }),
    TIMESTAMP(93, false, false, new Timestamp(0L), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Timestamp.valueOf(t);
        }
        catch (RuntimeException rex) {
            return new Timestamp(0L);
        }
    }),
    LONGVARBINARY(-4, false, false, null, t -> null),
    DECIMAL(3, true, true, new BigDecimal(0), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return BigDecimal.valueOf(Double.valueOf(t));
        }
        catch (RuntimeException rex) {
            return new BigDecimal(0);
        }
    }),
    CHAR(1, false, false, Character.valueOf(' '), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Character.valueOf(t.isEmpty() ? (char)' ' : t.charAt(0));
        }
        catch (RuntimeException rex) {
            return Character.valueOf(' ');
        }
    }),
    BIT(-7, false, false, false, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Boolean.valueOf(t);
        }
        catch (RuntimeException rex) {
            return false;
        }
    }),
    TINYINT(-6, true, false, (byte)0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Byte.valueOf(t);
        }
        catch (RuntimeException rex) {
            return (byte)0;
        }
    }),
    SMALLINT(5, true, false, (short)0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Short.valueOf(t);
        }
        catch (RuntimeException rex) {
            return (short)0;
        }
    }),
    INTEGER(4, true, false, 0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Integer.valueOf(t);
        }
        catch (RuntimeException rex) {
            return 0;
        }
    }),
    BIGINT(-5, true, false, 0L, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Long.valueOf(t);
        }
        catch (RuntimeException rex) {
            return 0L;
        }
    }),
    FLOAT(6, true, true, Float.valueOf(0.0f), t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Float.valueOf(t);
        }
        catch (RuntimeException rex) {
            return Float.valueOf(0.0f);
        }
    }),
    DOUBLE(8, true, true, 0.0, t -> {
        t = SqlType.removeSingleQuotes(t);
        try {
            return Double.valueOf(t);
        }
        catch (RuntimeException rex) {
            return 0.0;
        }
    }),
    JAVA_OBJECT(2000, false, false, null, t -> null);

    private final int jdbcType;
    private final boolean numeric;
    private final boolean fractional;
    private final Object defaultValue;
    private final Function<String, Object> parser;

    private static String removeSingleQuotes(String str) {
        if (str != null && str.length() >= 2 && str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private SqlType(int jdbcType, boolean numeric, boolean fractional, Object defaultValue, Function<String, Object> parser) {
        this.jdbcType = jdbcType;
        this.numeric = numeric;
        this.fractional = fractional;
        this.defaultValue = defaultValue;
        this.parser = parser;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isFractional() {
        return this.fractional;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object parse(String str) {
        return this.parser.apply(str);
    }
}

