/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.AbstractSql2003Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.SqlType;

@Service(value=Backend.class)
public class MsSql
extends AbstractSql2003Backend {
    public static final String SQL_TOP = "TOP ";
    public static final String SQL_TOP_PAR = "TOP ? ";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":sqlserver");
    }

    @Override
    public String getName() {
        return "MsSQL";
    }

    @Override
    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT @@SPID");
            if (rs.next()) {
                String string = "ID-" + rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new TentackleRuntimeException("cannot determine backend id", (Throwable)ex);
        }
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        if (limit > 0 && offset <= 0) {
            sqlBuilder.insert(0, SQL_TOP_PAR);
            sqlBuilder.insert(0, "SELECT ");
        } else {
            super.buildSelectSql(sqlBuilder, writeLock, limit, offset);
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        int index = 1;
        if (limit > 0 && offset <= 0) {
            stmt.setInt(index++, limit);
        }
        return index;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (limit > 0 && offset <= 0) {
            return index;
        }
        return super.setTrailingSelectParameters(stmt, index, limit, offset);
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 38;
            }
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "BIT";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INT";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case DOUBLE: {
                return "FLOAT";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case CHAR: {
                return "NCHAR(1)";
            }
            case VARCHAR: {
                return size == 0 ? "NVARCHAR(MAX)" : "NVARCHAR";
            }
            case DATE: {
                return "DATETIME";
            }
            case TIME: {
                return "DATETIME";
            }
            case TIMESTAMP: {
                return "DATETIME";
            }
            case LONGVARBINARY: {
                return "VARBINARY(MAX)";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT, SqlType.SMALLINT};
            }
            case 91: 
            case 92: 
            case 93: {
                return new SqlType[]{SqlType.DATE, SqlType.TIME, SqlType.TIMESTAMP};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = sql.indexOf(SQL_TOP);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with TOP");
        }
        return super.extractWhereClause(sql, whereOffset);
    }
}

