/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import org.tentackle.sql.BackendInfo;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.JoinType;
import org.tentackle.sql.MigrationStrategy;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.ModelMetaData;
import org.tentackle.sql.metadata.TableMetaData;

public interface Backend {
    public static final String SQL_WHERE = " WHERE ";
    public static final String SQL_SELECT = "SELECT ";
    public static final String SQL_SELECT_ALL_FROM = "SELECT * FROM ";
    public static final String SQL_DELETE = "DELETE ";
    public static final String SQL_UPDATE = "UPDATE ";
    public static final String SQL_INSERT_INTO = "INSERT INTO ";
    public static final String SQL_LEFT_PARENTHESIS = " (";
    public static final String SQL_RIGHT_PARENTHESIS = ") ";
    public static final String SQL_INSERT_VALUES = ") VALUES (";
    public static final String SQL_SET = " SET ";
    public static final String SQL_FROM = " FROM ";
    public static final String SQL_AND = " AND ";
    public static final String SQL_OR = " OR ";
    public static final String SQL_NOT = "NOT ";
    public static final String SQL_ANDNOT = " AND NOT ";
    public static final String SQL_ORNOT = " OR NOT ";
    public static final String SQL_COMMA = ",";
    public static final String SQL_PAR = "?";
    public static final String SQL_EQUAL = "=";
    public static final String SQL_NOTEQUAL = "<>";
    public static final String SQL_LESS = "<";
    public static final String SQL_GREATER = ">";
    public static final String SQL_LESSOREQUAL = "<=";
    public static final String SQL_GREATEROREQUAL = ">=";
    public static final String SQL_LIKE = " LIKE ";
    public static final String SQL_NOTLIKE = " NOT LIKE ";
    public static final String SQL_EQUAL_ZERO = "=0";
    public static final String SQL_NOTEQUAL_ZERO = "<>0";
    public static final String SQL_COMMA_PAR = ",?";
    public static final String SQL_PAR_COMMA = "?,";
    public static final String SQL_EQUAL_PAR = "=?";
    public static final String SQL_EQUAL_PAR_COMMA = "=?,";
    public static final String SQL_NOTEQUAL_PAR = "<>?";
    public static final String SQL_GREATER_PAR = ">?";
    public static final String SQL_GREATEROREQUAL_PAR = ">=?";
    public static final String SQL_LESS_PAR = "<?";
    public static final String SQL_LESSOREQUAL_PAR = "<=?";
    public static final String SQL_LIKE_PAR = " LIKE ?";
    public static final String SQL_NOTLIKE_PAR = " NOT LIKE ?";
    public static final String SQL_ALLSTAR = "*";
    public static final String SQL_PLUS_ONE = "+1";
    public static final String SQL_WHEREALL = " WHERE 1=1";
    public static final String SQL_WHERENOTHING = " WHERE 1=0";
    public static final String SQL_WHEREAND = " WHERE 1=1 AND ";
    public static final String SQL_WHEREOR = " WHERE 1=1 OR ";
    public static final String SQL_ISNULL = " IS NULL";
    public static final String SQL_ISNOTNULL = " IS NOT NULL";
    public static final String SQL_ORDERBY = " ORDER BY ";
    public static final String SQL_SORTASC = " ASC";
    public static final String SQL_SORTDESC = " DESC";
    public static final String SQL_GROUPBY = " GROUP BY ";
    public static final String SQL_MAX = "MAX";
    public static final String SQL_MIN = "MIN";
    public static final String SQL_EXISTS = "EXISTS (SELECT 1 FROM ";

    public boolean isMatchingUrl(String var1);

    public boolean isMatchingName(String var1);

    public String getName();

    public String getDriverClassName();

    public Connection createConnection(String var1, String var2, char[] var3) throws SQLException;

    public DatabaseMetaData[] getMetaData(BackendInfo var1) throws SQLException;

    public boolean isTemporaryName(String var1);

    public void buildSelectSql(StringBuilder var1, boolean var2, int var3, int var4);

    public String buildSelectSql(String var1, boolean var2, int var3, int var4);

    public int setLeadingSelectParameters(BackendPreparedStatement var1, int var2, int var3);

    public int setTrailingSelectParameters(BackendPreparedStatement var1, int var2, int var3, int var4);

    public String getEmptyString();

    public boolean sqlRequiresExtraCommit();

    public boolean sqlResultSetIsClosedSupported();

    public String getCoalesceKeyword();

    public boolean allowsExpressionsReferringToTablesBeingUpdated();

    public boolean supportsSequences();

    public String sqlAsBeforeTableAlias();

    public boolean needAliasForSubselect();

    public String sqlNextFromSequene(String var1);

    public String sqlComment(String var1);

    public String sqlJoin(JoinType var1, String var2, String var3, String var4);

    public String sqlFunction(String var1, String var2);

    public boolean needSetLongWorkaround();

    public boolean needTxForFetchsize();

    public boolean isConstraintException(SQLException var1);

    public boolean isCommunicationLinkException(SQLException var1);

    public int getMaxSize(SqlType var1);

    public int getMaxScale(SqlType var1, int var2);

    public int getDefaultSize(SqlType var1);

    public String getDefaultSchema();

    public Set<String> getReservedWords();

    public void assertValidName(String var1, String var2);

    public String getBackendId(Connection var1);

    public ModelMetaData getModelMetaData(DatabaseMetaData[] var1, String[] var2, String ... var3);

    public ColumnMetaData createColumnMetaData(TableMetaData var1);

    public TableMetaData createTableMetaData(ModelMetaData var1, String var2);

    public IndexMetaData createIndexMetaData(TableMetaData var1);

    public IndexColumnMetaData createIndexColumnMetaData(IndexMetaData var1);

    public String sqlTypeToString(SqlType var1, int var2);

    public String columnTypeToString(SqlType var1, int var2, int var3);

    public String columnTypeNullDefaultToString(String var1, SqlType var2, int var3, int var4, boolean var5, Object var6);

    public String valueToLiteral(SqlType var1, Object var2);

    public String sqlCreateTableIntro(String var1, String var2);

    public String sqlCreateTableClosing(String var1, String var2);

    public String sqlCreateTableComment(String var1, String var2);

    public String sqlAlterTableComment(String var1, String var2);

    public String sqlCreateColumn(String var1, String var2, SqlType var3, int var4, int var5, boolean var6, Object var7, boolean var8, boolean var9);

    public boolean isDefaultEqual(ColumnMetaData var1, SqlType var2, Object var3);

    public MigrationStrategy[] getMigrationStrategy(ColumnMetaData var1, String var2, String var3, SqlType var4, int var5, int var6, boolean var7, Object var8);

    public String sqlRenameColumn(String var1, String var2, String var3);

    public String sqlRenameAndAlterColumnType(String var1, String var2, String var3, String var4, SqlType var5, int var6, int var7, boolean var8, Object var9);

    public String sqlAddColumn(String var1, String var2, String var3, SqlType var4, int var5, int var6, boolean var7, Object var8);

    public String sqlDropColumn(String var1, String var2);

    public String sqlAlterColumnType(String var1, String var2, String var3, SqlType var4, int var5, int var6, boolean var7, Object var8);

    public String sqlUpdateToNotNull(String var1, String var2, SqlType var3, Object var4);

    public String sqlAlterColumnNullConstraint(String var1, String var2, boolean var3);

    public String sqlAlterColumnDefault(String var1, String var2, SqlType var3, Object var4);

    public String sqlCreateColumnComment(String var1, String var2, String var3);

    public String sqlCreateIndex(String var1, String var2, boolean var3, String var4, String ... var5);

    public String sqlDropIndex(String var1, String var2, String var3);

    public String sqlCreateForeignKey(String var1, String var2, String var3, String var4, String var5, boolean var6);

    public String sqlDropForeignKey(String var1, String var2);

    public String sqlAlterColumnComment(String var1, String var2, String var3);

    public void sqlJoinSelects(JoinType var1, boolean var2, StringBuilder var3, String var4, String var5, String var6, String var7);

    public String sqlJoinSelects(JoinType var1, boolean var2, String var3, String var4, String var5, String var6, String var7);

    public SqlType[] jdbcTypeToSqlType(int var1, int var2, int var3);

    public TableMetaData getTableMetaData(ModelMetaData var1, String var2);

    public String toQuotedString(String var1);

    public String optimizeSql(String var1);

    public boolean isReleaseSavepointSupported();
}

