/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.ModelMetaData;

public class TableMetaData {
    protected final ModelMetaData modelMetaData;
    protected final String modelTableName;
    protected String schemaName;
    protected String tableName;
    protected String comment;
    protected final Collection<ColumnMetaData> columns;
    protected final Map<String, IndexMetaData> indexes;
    protected final Map<String, ForeignKeyMetaData> foreignKeys;

    public TableMetaData(ModelMetaData modelMetaData, String modelTableName) {
        this.modelMetaData = modelMetaData;
        this.modelTableName = modelTableName;
        this.columns = new ArrayList<ColumnMetaData>();
        this.indexes = new TreeMap<String, IndexMetaData>();
        this.foreignKeys = new TreeMap<String, ForeignKeyMetaData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupTableFromMetaData(DatabaseMetaData metaData, String schemaPattern, String tablePattern) throws SQLException {
        ResultSet resultSet;
        block25: {
            resultSet = metaData.getTables(null, schemaPattern, tablePattern, null);
            try {
                if (resultSet.next()) {
                    this.schemaName = resultSet.getString("TABLE_SCHEM");
                    this.tableName = resultSet.getString("TABLE_NAME");
                    this.comment = resultSet.getString("REMARKS");
                    break block25;
                }
                throw new BackendException("no metadata for schema " + schemaPattern + ", table " + tablePattern);
            }
            finally {
                resultSet.close();
            }
        }
        resultSet = metaData.getColumns(null, schemaPattern, tablePattern, null);
        try {
            while (resultSet.next()) {
                String schema = resultSet.getString("TABLE_SCHEM");
                String table = resultSet.getString("TABLE_NAME");
                if (schema != null && this.schemaName != null && !this.schemaName.equals(schema)) {
                    throw new BackendException("different schemas apply to '" + (schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + this.schemaName + " != " + schema);
                }
                if (schema == null && this.schemaName != null || schema != null && this.schemaName == null) {
                    throw new BackendException("null- and non-null schemas found for '" + (schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + (this.schemaName == null ? "<null>" : this.schemaName) + " != " + (schema == null ? "<null>" : schema));
                }
                if (table != null && this.tableName != null && !this.tableName.equals(table)) {
                    throw new BackendException("different tablenames apply to '" + (schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + this.tableName + " != " + table);
                }
                if (table == null && this.tableName != null || table != null && this.tableName == null) {
                    throw new BackendException("null- and non-null tablenames found for '" + (schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + (this.tableName == null ? "<null>" : this.tableName) + " != " + (table == null ? "<null>" : table));
                }
                ColumnMetaData columnMetaData = this.modelMetaData.getBackend().createColumnMetaData(this);
                columnMetaData.setupColumnFromMetaData(resultSet);
                if (columnMetaData.getColumnName() == null || columnMetaData.getColumnName().startsWith("_")) continue;
                this.columns.add(columnMetaData);
            }
        }
        finally {
            resultSet.close();
        }
        resultSet = metaData.getIndexInfo(null, this.schemaName, this.tableName, false, false);
        try {
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                if (indexName == null || indexName.startsWith("_")) continue;
                IndexMetaData indexMetaData = this.indexes.get(indexName);
                if (indexMetaData == null) {
                    indexMetaData = this.modelMetaData.getBackend().createIndexMetaData(this);
                    indexMetaData.setupIndexFromMetaData(resultSet);
                    this.indexes.put(indexName, indexMetaData);
                }
                indexMetaData.addIndexColumnFromMetaData(resultSet);
            }
        }
        finally {
            resultSet.close();
        }
        ForeignKeyMetaData foreignKeyMetaData = null;
        resultSet = metaData.getImportedKeys(null, this.schemaName, this.tableName);
        try {
            while (resultSet.next()) {
                short keySeq = resultSet.getShort("KEY_SEQ");
                if (keySeq == 1) {
                    foreignKeyMetaData = new ForeignKeyMetaData(this);
                    foreignKeyMetaData.setupForeignKeyFromMetaData(resultSet);
                    if (foreignKeyMetaData.getForeignKeyName() != null && !foreignKeyMetaData.getForeignKeyName().startsWith("_")) {
                        this.foreignKeys.put(foreignKeyMetaData.getForeignKeyName(), foreignKeyMetaData);
                    }
                } else if (foreignKeyMetaData == null) {
                    throw new BackendException("unexpected KEY_SEQ " + keySeq + " in " + foreignKeyMetaData);
                }
                ForeignKeyColumnMetaData column = new ForeignKeyColumnMetaData(foreignKeyMetaData);
                column.setupForeignKeyColumnFromMetaData(resultSet);
                foreignKeyMetaData.addForeignKeyColumn(column);
            }
        }
        finally {
            resultSet.close();
        }
        this.validate();
    }

    public ModelMetaData getModelMetaData() {
        return this.modelMetaData;
    }

    public String getModelTableName() {
        return this.modelTableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public String getComment() {
        return this.comment;
    }

    public Collection<ColumnMetaData> getColumns() {
        return this.columns;
    }

    public ColumnMetaData getColumnByName(String columnName) {
        columnName = columnName.toLowerCase();
        for (ColumnMetaData column : this.columns) {
            if (!column.getColumnName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public Collection<IndexMetaData> getIndexes() {
        return this.indexes.values();
    }

    public Collection<ForeignKeyMetaData> getForeignKeys() {
        return this.foreignKeys.values();
    }

    public void validate() {
        if (this.comment != null && this.comment.isEmpty()) {
            this.comment = null;
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.schemaName);
        hash = 71 * hash + Objects.hashCode(this.tableName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableMetaData other = (TableMetaData)obj;
        if (!Objects.equals(this.schemaName, other.schemaName)) {
            return false;
        }
        return Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("TABLE ");
        buf.append(this.getFullTableName());
        buf.append(" (");
        for (ColumnMetaData column : this.getColumns()) {
            buf.append("\n    ");
            buf.append(column);
        }
        buf.append("\n)");
        for (IndexMetaData index : this.getIndexes()) {
            buf.append("\n");
            buf.append(index);
        }
        for (ForeignKeyMetaData foreignKey : this.getForeignKeys()) {
            buf.append("\n");
            buf.append(foreignKey);
        }
        buf.append("\n");
        return buf.toString();
    }
}

