/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.DatabaseMetaData;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tentackle.sql.Backend;
import org.tentackle.sql.metadata.TableMetaData;

public class ModelMetaData {
    protected final Backend backend;
    protected final DatabaseMetaData[] metaData;
    protected final Map<String, TableMetaData> tableMap;
    protected final String[] schemas;

    public ModelMetaData(Backend backend, DatabaseMetaData[] metaData, String[] schemas) {
        this.backend = backend;
        this.metaData = metaData;
        this.tableMap = new TreeMap<String, TableMetaData>();
        this.schemas = schemas;
    }

    public boolean addTableMetaData(TableMetaData tableMetaData) {
        boolean add = false;
        if (this.schemas != null) {
            for (String schema : this.schemas) {
                if (tableMetaData.getSchemaName() == null || !tableMetaData.getSchemaName().equalsIgnoreCase(schema)) continue;
                add = true;
                break;
            }
        } else {
            add = true;
        }
        if (add) {
            this.tableMap.put(tableMetaData.getModelTableName(), tableMetaData);
        }
        return add;
    }

    public Collection<TableMetaData> getTables() {
        return this.tableMap.values();
    }

    public Backend getBackend() {
        return this.backend;
    }

    public DatabaseMetaData[] getMetaData() {
        return this.metaData;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (TableMetaData table : this.getTables()) {
            buf.append("\n");
            buf.append(table);
        }
        return buf.toString();
    }
}

