/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.TableMetaData;

public class IndexMetaData {
    protected final TableMetaData tableMetaData;
    protected final List<IndexColumnMetaData> columns;
    protected String indexName;
    protected boolean unique;
    protected String filterCondition;

    public IndexMetaData(TableMetaData tableMetaData) {
        this.tableMetaData = tableMetaData;
        this.columns = new ArrayList<IndexColumnMetaData>();
    }

    public void setupIndexFromMetaData(ResultSet resultSet) throws SQLException {
        this.indexName = BasicStringHelper.toLower((String)resultSet.getString("INDEX_NAME"));
        int dotNdx = this.indexName.indexOf(46);
        if (dotNdx >= 0) {
            this.indexName = this.indexName.substring(dotNdx + 1);
        }
        this.unique = !resultSet.getBoolean("NON_UNIQUE");
        this.filterCondition = resultSet.getString("FILTER_CONDITION");
        this.validate();
    }

    public void addIndexColumnFromMetaData(ResultSet resultSet) throws SQLException {
        IndexColumnMetaData column = this.tableMetaData.getModelMetaData().getBackend().createIndexColumnMetaData(this);
        column.setupIndexColumnFromMetaData(resultSet);
        this.columns.add(column);
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public List<IndexColumnMetaData> getColumns() {
        return this.columns;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public boolean isPrimaryIdKey() {
        return this.unique && this.columns.size() == 1 && this.columns.get(0).getColumnName().equals("id");
    }

    public void validate() {
        if (BasicStringHelper.isAllWhitespace((String)this.filterCondition)) {
            this.filterCondition = null;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isUnique()) {
            buf.append("UNIQUE ");
        }
        buf.append("INDEX ");
        buf.append(this.getIndexName());
        buf.append(" ON ");
        buf.append(this.getTableMetaData().getFullTableName());
        buf.append(" (");
        boolean needComma = false;
        for (IndexColumnMetaData column : this.getColumns()) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(column);
            needComma = true;
        }
        buf.append(")");
        if (this.getFilterCondition() != null) {
            buf.append(" WHERE ").append(this.getFilterCondition());
        }
        return buf.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.tableMetaData);
        hash = 43 * hash + Objects.hashCode(this.indexName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexMetaData other = (IndexMetaData)obj;
        if (!Objects.equals(this.tableMetaData, other.tableMetaData)) {
            return false;
        }
        return Objects.equals(this.indexName, other.indexName);
    }
}

