/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.sql.metadata.IndexMetaData;

public class IndexColumnMetaData
implements Comparable<IndexColumnMetaData> {
    protected final IndexMetaData indexMetaData;
    protected String columnName;
    protected boolean descending;
    protected int position;

    public IndexColumnMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public void setupIndexColumnFromMetaData(ResultSet resultSet) throws SQLException {
        this.columnName = BasicStringHelper.toLower((String)resultSet.getString("COLUMN_NAME"));
        String ascDesc = resultSet.getString("ASC_OR_DESC");
        this.descending = ascDesc != null && ascDesc.startsWith("D");
        this.position = resultSet.getShort("ORDINAL_POSITION");
        this.validate();
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public int compareTo(IndexColumnMetaData o) {
        return this.position - o.position;
    }

    public void validate() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.columnName);
        if (this.descending) {
            buf.append(" DESC");
        }
        return buf.toString();
    }
}

