/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.sql.metadata.ForeignKeyAction;
import org.tentackle.sql.metadata.ForeignKeyColumnMetaData;
import org.tentackle.sql.metadata.TableMetaData;

public class ForeignKeyMetaData {
    protected final TableMetaData tableMetaData;
    protected String foreignKeySchema;
    protected String foreignKeyTable;
    protected String foreignKeyName;
    protected String primaryKeySchema;
    protected String primaryKeyTable;
    protected ForeignKeyAction updateRule;
    protected ForeignKeyAction deleteRule;
    protected final Set<ForeignKeyColumnMetaData> columns;

    public ForeignKeyMetaData(TableMetaData tableMetaData) {
        this.tableMetaData = tableMetaData;
        this.columns = new TreeSet<ForeignKeyColumnMetaData>();
    }

    public void addForeignKeyColumn(ForeignKeyColumnMetaData column) {
        this.columns.add(column);
    }

    public List<ForeignKeyColumnMetaData> getForeignKeyColumns() {
        return new ArrayList<ForeignKeyColumnMetaData>(this.columns);
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public String getForeignKeySchema() {
        return this.foreignKeySchema;
    }

    public String getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public String getFullForeignKeyTableName() {
        StringBuilder buf = new StringBuilder();
        if (this.foreignKeySchema != null) {
            buf.append(this.foreignKeySchema);
            buf.append('.');
        }
        buf.append(this.foreignKeyTable);
        return buf.toString();
    }

    public String getPrimaryKeySchema() {
        return this.primaryKeySchema;
    }

    public String getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    public String getFullPrimaryKeyTableName() {
        StringBuilder buf = new StringBuilder();
        if (this.primaryKeySchema != null) {
            buf.append(this.primaryKeySchema);
            buf.append('.');
        }
        buf.append(this.primaryKeyTable);
        return buf.toString();
    }

    public ForeignKeyAction getUpdateRule() {
        return this.updateRule;
    }

    public ForeignKeyAction getDeleteRule() {
        return this.deleteRule;
    }

    public void setupForeignKeyFromMetaData(ResultSet resultSet) throws SQLException {
        this.foreignKeySchema = BasicStringHelper.toLower((String)resultSet.getString("FKTABLE_SCHEM"));
        this.foreignKeyTable = BasicStringHelper.toLower((String)resultSet.getString("FKTABLE_NAME"));
        this.foreignKeyName = BasicStringHelper.toLower((String)resultSet.getString("FK_NAME"));
        int dotNdx = this.foreignKeyName.indexOf(46);
        if (dotNdx >= 0) {
            this.foreignKeyName = this.foreignKeyName.substring(dotNdx + 1);
        }
        this.primaryKeySchema = BasicStringHelper.toLower((String)resultSet.getString("PKTABLE_SCHEM"));
        this.primaryKeyTable = BasicStringHelper.toLower((String)resultSet.getString("PKTABLE_NAME"));
        this.updateRule = ForeignKeyAction.createFromAction(resultSet.getShort("UPDATE_RULE"));
        this.deleteRule = ForeignKeyAction.createFromAction(resultSet.getShort("DELETE_RULE"));
        this.validate();
    }

    public void validate() {
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.tableMetaData);
        hash = 79 * hash + Objects.hashCode(this.foreignKeyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKeyMetaData other = (ForeignKeyMetaData)obj;
        if (!Objects.equals(this.tableMetaData, other.tableMetaData)) {
            return false;
        }
        return Objects.equals(this.foreignKeyName, other.foreignKeyName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("FOREIGN KEY ");
        buf.append(this.foreignKeyName);
        buf.append(" (");
        boolean needComma = false;
        for (ForeignKeyColumnMetaData column : this.columns) {
            if (needComma) {
                buf.append(", ");
            } else {
                needComma = true;
            }
            buf.append(column);
        }
        buf.append(") REFERENCES ");
        if (this.primaryKeySchema != null) {
            buf.append(this.primaryKeySchema);
            buf.append(".");
        }
        buf.append(this.primaryKeyTable);
        buf.append(" (");
        needComma = false;
        for (ForeignKeyColumnMetaData column : this.columns) {
            if (needComma) {
                buf.append(", ");
            } else {
                needComma = true;
            }
            buf.append(column.getPrimaryKeyColumn());
        }
        buf.append(")");
        if (this.updateRule != null) {
            buf.append(" ON UPDATE ");
            buf.append((Object)this.updateRule);
        }
        if (this.deleteRule != null) {
            buf.append(" ON DELETE ");
            buf.append((Object)this.deleteRule);
        }
        return buf.toString();
    }
}

