/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.metadata.ForeignKeyAction;
import org.tentackle.sql.metadata.ForeignKeyMetaData;

public class ForeignKeyColumnMetaData
implements Comparable<ForeignKeyColumnMetaData> {
    protected final ForeignKeyMetaData foreignKeyMetaData;
    protected int position;
    protected String foreignKeyColumn;
    protected String primaryKeyColumn;

    public ForeignKeyColumnMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public int getPosition() {
        return this.position;
    }

    public String getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public String getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public void setupForeignKeyColumnFromMetaData(ResultSet resultSet) throws SQLException {
        this.position = resultSet.getShort("KEY_SEQ");
        this.foreignKeyColumn = BasicStringHelper.toLower((String)resultSet.getString("FKCOLUMN_NAME"));
        this.primaryKeyColumn = BasicStringHelper.toLower((String)resultSet.getString("PKCOLUMN_NAME"));
        String val = BasicStringHelper.toLower((String)resultSet.getString("FKTABLE_SCHEM"));
        if (!Objects.equals(val, this.foreignKeyMetaData.getForeignKeySchema())) {
            throw new BackendException("inconsistent referencing schema in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + this + ", found " + val + ", expected " + this.foreignKeyMetaData.getForeignKeySchema());
        }
        val = BasicStringHelper.toLower((String)resultSet.getString("FKTABLE_NAME"));
        if (!Objects.equals(val, this.foreignKeyMetaData.getForeignKeyTable())) {
            throw new BackendException("inconsistent referencing table in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + this + ", found " + val + ", expected " + this.foreignKeyMetaData.getForeignKeyTable());
        }
        val = BasicStringHelper.toLower((String)resultSet.getString("PKTABLE_SCHEM"));
        if (!Objects.equals(val, this.foreignKeyMetaData.getPrimaryKeySchema())) {
            throw new BackendException("inconsistent referenced schema in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + this + ", found " + val + ", expected " + this.foreignKeyMetaData.getPrimaryKeySchema());
        }
        val = BasicStringHelper.toLower((String)resultSet.getString("PKTABLE_NAME"));
        if (!Objects.equals(val, this.foreignKeyMetaData.getPrimaryKeyTable())) {
            throw new BackendException("inconsistent referenced table in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + this + ", found " + val + ", expected " + this.foreignKeyMetaData.getPrimaryKeyTable());
        }
        ForeignKeyAction action = ForeignKeyAction.createFromAction(resultSet.getShort("UPDATE_RULE"));
        if (!Objects.equals((Object)action, (Object)this.foreignKeyMetaData.getUpdateRule())) {
            throw new BackendException("inconsistent update rule in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + this + ", found " + (Object)((Object)action) + ", expected " + (Object)((Object)this.foreignKeyMetaData.getUpdateRule()));
        }
        action = ForeignKeyAction.createFromAction(resultSet.getShort("DELETE_RULE"));
        if (!Objects.equals((Object)action, (Object)this.foreignKeyMetaData.getDeleteRule())) {
            throw new BackendException("inconsistent delete rule in " + this.foreignKeyMetaData.getTableMetaData().getFullTableName() + ": " + this.foreignKeyMetaData.getForeignKeyName() + "." + this + ", found " + (Object)((Object)action) + ", expected " + (Object)((Object)this.foreignKeyMetaData.getDeleteRule()));
        }
        this.validate();
    }

    public void validate() {
    }

    @Override
    public int compareTo(ForeignKeyColumnMetaData o) {
        return this.position - o.position;
    }

    public String toString() {
        return this.foreignKeyColumn;
    }
}

