/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.metadata.MetaDataHelper;
import org.tentackle.sql.metadata.TableMetaData;

public class ColumnMetaData
implements Cloneable {
    protected final TableMetaData tableMetaData;
    protected String columnName;
    protected String comment;
    protected int type;
    protected String typeName;
    protected int size;
    protected int scale;
    protected String defaultValue;
    protected boolean nullable;
    protected boolean generated;
    protected boolean autoIncrement;

    public ColumnMetaData(TableMetaData tableMetaData) {
        this.tableMetaData = tableMetaData;
    }

    public TableMetaData getTableMetaData() {
        return this.tableMetaData;
    }

    public void setupColumnFromMetaData(ResultSet resultSet) throws SQLException {
        this.columnName = BasicStringHelper.toLower((String)resultSet.getString("COLUMN_NAME"));
        this.comment = resultSet.getString("REMARKS");
        this.size = resultSet.getInt("COLUMN_SIZE");
        this.scale = resultSet.getShort("DECIMAL_DIGITS");
        this.nullable = resultSet.getInt("NULLABLE") == 1;
        this.type = resultSet.getInt("DATA_TYPE");
        this.typeName = resultSet.getString("TYPE_NAME");
        this.defaultValue = resultSet.getString("COLUMN_DEF");
        this.autoIncrement = Objects.equals("YES", resultSet.getString("IS_AUTOINCREMENT"));
        try {
            this.generated = Objects.equals("YES", resultSet.getString("IS_GENERATEDCOLUMN"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.validate();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getComment() {
        return this.comment;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSize() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean matchesSqlType(SqlType sqlType) {
        Backend backend = this.tableMetaData.getModelMetaData().getBackend();
        SqlType[] possibleSqlTypes = backend.jdbcTypeToSqlType(this.type, this.size, this.scale);
        if (possibleSqlTypes != null) {
            for (SqlType possibleType : possibleSqlTypes) {
                if (sqlType != possibleType) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.columnName);
        buf.append(" ");
        buf.append(MetaDataHelper.jdbcTypeToString(this.type));
        if (this.size > 0) {
            buf.append("(");
            buf.append(this.size);
            if (this.scale > 0) {
                buf.append(",");
                buf.append(this.scale);
            }
            buf.append(")");
        }
        if (!this.nullable) {
            buf.append(" NOT NULL");
        }
        if (this.defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(this.defaultValue);
        }
        if (this.autoIncrement) {
            buf.append(" AUTOINCREMENT");
        }
        buf.append(" -- ");
        buf.append(this.typeName);
        if (this.generated) {
            buf.append(", GENERATED");
        }
        return buf.toString();
    }

    public void validate() {
        if (this.comment != null && this.comment.isEmpty()) {
            this.comment = null;
        }
        if (this.defaultValue != null && this.defaultValue.isEmpty()) {
            this.defaultValue = null;
        }
    }
}

