/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public enum SqlType {
    VARCHAR(12, false, false, ""),
    DATE(91, false, false, new Date(0L)),
    TIME(92, false, false, new Time(0L)),
    TIMESTAMP(93, false, false, new Timestamp(0L)),
    LONGVARBINARY(-4, false, false, null),
    DECIMAL(3, true, true, new BigDecimal(0)),
    CHAR(1, false, false, Character.valueOf(' ')),
    BIT(-7, false, false, false),
    TINYINT(-6, true, false, (byte)0),
    SMALLINT(5, true, false, (short)0),
    INTEGER(4, true, false, 0),
    BIGINT(-5, true, false, 0L),
    FLOAT(6, true, true, Float.valueOf(0.0f)),
    DOUBLE(8, true, true, 0.0),
    JAVA_OBJECT(2000, false, false, null);

    private final int sqlType;
    private final boolean numeric;
    private final boolean fractional;
    private final Object defaultValue;

    private SqlType(int sqlType, boolean numeric, boolean fractional, Object defaultValue) {
        this.sqlType = sqlType;
        this.numeric = numeric;
        this.fractional = fractional;
        this.defaultValue = defaultValue;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isFractional() {
        return this.fractional;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

