/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import org.tentackle.sql.Backend;

public class NonStandardCommons {
    public static String sqlCreateCommentOnTable(Backend backend, String tableName, String comment) {
        StringBuilder buf = new StringBuilder("COMMENT ON TABLE ");
        buf.append(tableName);
        buf.append(" IS ");
        buf.append(backend.toQuotedString(comment));
        buf.append(";\n");
        return buf.toString();
    }

    public static String sqlCreateCommentOnColumn(Backend backend, String tableName, String columnName, String comment) {
        StringBuilder buf = new StringBuilder("COMMENT ON COLUMN ");
        buf.append(tableName);
        buf.append(".");
        buf.append(columnName);
        buf.append(" IS ");
        if (comment == null) {
            buf.append("NULL");
        } else {
            buf.append(backend.toQuotedString(comment));
        }
        buf.append(";\n");
        return buf.toString();
    }

    private NonStandardCommons() {
    }
}

