/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.AbstractSql2003Backend;
import org.tentackle.sql.Backend;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;

@Service(value=Backend.class)
public class Db2
extends AbstractSql2003Backend {
    private static final String STR_CONTINUATION = " \\";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":db2");
    }

    @Override
    public String getName() {
        return "DB2";
    }

    @Override
    public String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public boolean sqlResultSetIsClosedSupported() {
        return true;
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        switch (sqlType) {
            case DECIMAL: {
                return 31;
            }
            case VARCHAR: {
                return 512;
            }
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public String getBackendId(Connection connection) {
        String backendId = null;
        ResultSet rs = null;
        try {
            Statement stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT application_id() AS appid FROM SYSIBM.SYSDUMMY1");
            if (rs.next()) {
                backendId = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            throw new TentackleRuntimeException("cannot determine backend id", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    throw new TentackleRuntimeException("close resultset after determine backend id failed", (Throwable)ex);
                }
            }
        }
        return backendId;
    }

    @Override
    public String sqlCreateTableIntro(String tableName, String comment) {
        return this.appendContinuationString(super.sqlCreateTableIntro(tableName, comment));
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "SMALLINT";
            }
            case TINYINT: {
                return "SMALLINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "DATE";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case LONGVARBINARY: {
                return "BLOB";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: {
                return new SqlType[]{SqlType.BIT, SqlType.TINYINT, SqlType.SMALLINT};
            }
            case 91: 
            case 92: {
                return new SqlType[]{SqlType.DATE, SqlType.TIME};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlCreateColumn(String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue, boolean primaryKey, boolean withTrailingComma) {
        return this.appendContinuationString(super.sqlCreateColumn(columnName, comment, sqlType, size, scale, nullable, defaultValue, primaryKey, withTrailingComma));
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ADD (");
        buf.append(this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false));
        buf.append(");\n");
        return buf.toString();
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ALTER COLUMN ");
        buf.append(columnName);
        buf.append(" DATA TYPE ");
        buf.append(this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false));
        buf.append(";\n");
        return buf.toString();
    }

    private String appendContinuationString(String sql) {
        sql = sql.endsWith("\n") ? sql.substring(0, sql.length() - 1) + STR_CONTINUATION + "\n" : sql + STR_CONTINUATION;
        return sql;
    }
}

