/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyColumnMetaData;
import org.tentackle.sql.metadata.ForeignKeyMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.ModelMetaData;

public class TableMetaData {
    private final ModelMetaData modelMetaData;
    private final String modelTableName;
    private String schemaName;
    private String tableName;
    private String comment;
    private final Collection<ColumnMetaData> columns;
    private final Map<String, IndexMetaData> indexes;
    private final Map<String, ForeignKeyMetaData> foreignKeys;

    public TableMetaData(ModelMetaData modelMetaData, String modelTableName) {
        this.modelMetaData = modelMetaData;
        this.modelTableName = modelTableName;
        this.columns = new ArrayList<ColumnMetaData>();
        this.indexes = new TreeMap<String, IndexMetaData>();
        this.foreignKeys = new TreeMap<String, ForeignKeyMetaData>();
    }

    public void setupTableFromMetaData(DatabaseMetaData metaData, String[] schemas, String schemaPattern, String tablePattern) throws SQLException {
        try (ResultSet resultSet = metaData.getTables(null, schemaPattern, tablePattern, null);){
            boolean valid = false;
            while (resultSet.next()) {
                this.schemaName = resultSet.getString("TABLE_SCHEM");
                this.tableName = resultSet.getString("TABLE_NAME");
                this.comment = resultSet.getString("REMARKS");
                if (!this.isValidSchema(this.schemaName, schemas)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new BackendException("no metadata for schema " + schemaPattern + ", table " + tablePattern);
            }
        }
        resultSet = metaData.getColumns(null, this.schemaName, this.tableName, null);
        try {
            while (resultSet.next()) {
                String schema = resultSet.getString("TABLE_SCHEM");
                String table = resultSet.getString("TABLE_NAME");
                if (schema != null && this.schemaName != null && !this.schemaName.equals(schema)) {
                    throw new BackendException("different schemas apply to '" + (String)(schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + this.schemaName + " != " + schema);
                }
                if (schema == null && this.schemaName != null || schema != null && this.schemaName == null) {
                    throw new BackendException("null- and non-null schemas found for '" + (String)(schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + (this.schemaName == null ? "<null>" : this.schemaName) + " != " + (schema == null ? "<null>" : schema));
                }
                if (table != null && this.tableName != null && !this.tableName.equals(table)) {
                    throw new BackendException("different tablenames apply to '" + (String)(schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + this.tableName + " != " + table);
                }
                if (table == null && this.tableName != null || table != null && this.tableName == null) {
                    throw new BackendException("null- and non-null tablenames found for '" + (String)(schemaPattern == null ? "" : schemaPattern + ".") + tablePattern + "': " + (this.tableName == null ? "<null>" : this.tableName) + " != " + (table == null ? "<null>" : table));
                }
                ColumnMetaData columnMetaData = this.modelMetaData.getBackend().createColumnMetaData(this);
                columnMetaData.setupColumnFromMetaData(resultSet);
                if (columnMetaData.getColumnName() == null || this.modelMetaData.getBackend().isTemporaryName(columnMetaData.getColumnName())) continue;
                this.columns.add(columnMetaData);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        resultSet = metaData.getIndexInfo(null, this.schemaName, this.tableName, false, false);
        try {
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                if (indexName == null || this.modelMetaData.getBackend().isTemporaryName(indexName)) continue;
                IndexMetaData indexMetaData = this.indexes.get(indexName);
                if (indexMetaData == null) {
                    indexMetaData = this.modelMetaData.getBackend().createIndexMetaData(this);
                    indexMetaData.setupIndexFromMetaData(resultSet);
                    this.indexes.put(indexName, indexMetaData);
                }
                indexMetaData.addIndexColumnFromMetaData(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        try (ResultSet resultSet = metaData.getImportedKeys(null, this.schemaName, this.tableName);){
            while (resultSet.next()) {
                ForeignKeyMetaData foreignKeyMetaData;
                short keySeq = resultSet.getShort("KEY_SEQ");
                if (keySeq == 1) {
                    foreignKeyMetaData = new ForeignKeyMetaData(this);
                    foreignKeyMetaData.setupForeignKeyFromMetaData(resultSet);
                    if (foreignKeyMetaData.getForeignKeyName() != null && !this.modelMetaData.getBackend().isTemporaryName(foreignKeyMetaData.getForeignKeyName())) {
                        this.foreignKeys.put(foreignKeyMetaData.getForeignKeyName(), foreignKeyMetaData);
                    }
                } else {
                    throw new BackendException("unexpected KEY_SEQ " + keySeq + " in foreign key meta data");
                }
                ForeignKeyColumnMetaData column = new ForeignKeyColumnMetaData(foreignKeyMetaData);
                column.setupForeignKeyColumnFromMetaData(resultSet);
                foreignKeyMetaData.addForeignKeyColumn(column);
            }
        }
        this.validate();
    }

    public ModelMetaData getModelMetaData() {
        return this.modelMetaData;
    }

    public String getModelTableName() {
        return this.modelTableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Collection<ColumnMetaData> getColumns() {
        return this.columns;
    }

    public ColumnMetaData getColumnByName(String columnName) {
        columnName = columnName.toLowerCase();
        for (ColumnMetaData column : this.columns) {
            if (!column.getColumnName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public Collection<IndexMetaData> getIndexes() {
        return this.indexes.values();
    }

    public Collection<ForeignKeyMetaData> getForeignKeys() {
        return this.foreignKeys.values();
    }

    public void validate() {
        String defaultSchema = this.getModelMetaData().getBackend().getDefaultSchema();
        if (defaultSchema != null && defaultSchema.equalsIgnoreCase(this.schemaName)) {
            this.schemaName = null;
        }
        if (this.comment != null && this.comment.isEmpty()) {
            this.comment = null;
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.schemaName);
        hash = 71 * hash + Objects.hashCode(this.tableName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableMetaData other = (TableMetaData)obj;
        if (!Objects.equals(this.schemaName, other.schemaName)) {
            return false;
        }
        return Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("TABLE ");
        buf.append(this.getFullTableName());
        buf.append(" (");
        for (ColumnMetaData column : this.getColumns()) {
            buf.append("\n    ");
            buf.append(column);
        }
        buf.append("\n)");
        for (IndexMetaData index : this.getIndexes()) {
            buf.append("\n");
            buf.append(index);
        }
        for (ForeignKeyMetaData foreignKey : this.getForeignKeys()) {
            buf.append("\n");
            buf.append(foreignKey);
        }
        buf.append("\n");
        return buf.toString();
    }

    private boolean isValidSchema(String schema, String[] schemas) {
        boolean valid = false;
        if (schemas != null) {
            if (schema != null) {
                for (String s : schemas) {
                    if (!s.equalsIgnoreCase(schema)) continue;
                    valid = true;
                    break;
                }
            }
        } else {
            valid = true;
        }
        return valid;
    }
}

