/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class TimeType
extends AbstractDateTimeType<Time> {
    @Override
    public String getJavaType() {
        return "Time";
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public SqlType getSqlType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIME;
    }

    @Override
    public Time valueOf(String str) {
        return this.parseTime(str);
    }

    @Override
    public String toString(Time object) {
        return StringHelper.toParsableString((String)this.printTime(object));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Time object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 92);
        } else {
            statement.setTime(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Time get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Time time = resultSet.getTime(pos[0]);
        return time == null ? null : org.tentackle.common.Time.createFrozen((long)time.getTime());
    }
}

