/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class LocalTimeType
extends AbstractDateTimeType<LocalTime> {
    @Override
    public String getJavaType() {
        return "LocalTime";
    }

    @Override
    public SqlType getSqlType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIME;
    }

    @Override
    public LocalTime valueOf(String str) {
        return this.parseTime(str).toLocalTime();
    }

    @Override
    public String toString(LocalTime object) {
        return StringHelper.toParsableString((String)this.printTime(Time.valueOf(object)));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, LocalTime object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 92);
        } else {
            statement.setTime(pos, Time.valueOf(object));
        }
        return new Object[]{object};
    }

    @Override
    public LocalTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Time time = resultSet.getTime(pos[0]);
        return time == null ? null : time.toLocalTime();
    }
}

