/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class LocalDateType
extends AbstractDateTimeType<LocalDate> {
    @Override
    public String getJavaType() {
        return "LocalDate";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public SqlType getSqlType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.DATE;
    }

    @Override
    public LocalDate valueOf(String str) {
        return this.parseDate(str).toLocalDate();
    }

    @Override
    public String toString(LocalDate object) {
        return StringHelper.toParsableString((String)this.printDate(Date.valueOf(object)));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, LocalDate object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = DateHelper.MIN_LOCALDATE;
            statement.setDate(pos, (Date)DateHelper.MIN_DATE);
        } else if (object == null) {
            statement.setNull(pos, 91);
        } else {
            statement.setDate(pos, Date.valueOf(object));
        }
        return new Object[]{object};
    }

    @Override
    public LocalDate get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Date date = resultSet.getDate(pos[0]);
        if (date == null || mapNull && date.equals(DateHelper.MIN_DATE)) {
            return null;
        }
        return date.toLocalDate();
    }
}

