/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class LocalDateTimeType
extends AbstractDateTimeType<LocalDateTime> {
    @Override
    public String getJavaType() {
        return "LocalDateTime";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public SqlType getSqlType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIMESTAMP;
    }

    @Override
    public LocalDateTime valueOf(String str) {
        return this.parseTimestamp(str).toLocalDateTime();
    }

    @Override
    public String toString(LocalDateTime object) {
        return StringHelper.toParsableString((String)this.printTimestamp(Timestamp.valueOf(object)));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, LocalDateTime object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = DateHelper.MIN_LOCALDATETIME;
            statement.setTimestamp(pos, (Timestamp)DateHelper.MIN_TIMESTAMP);
        } else if (object == null) {
            statement.setNull(pos, 93);
        } else {
            statement.setTimestamp(pos, Timestamp.valueOf(object));
        }
        return new Object[]{object};
    }

    @Override
    public LocalDateTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(pos[0]);
        if (timestamp == null || mapNull && timestamp.equals((Timestamp)DateHelper.MIN_TIMESTAMP)) {
            return null;
        }
        return timestamp.toLocalDateTime();
    }
}

