/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractNumberType;

@Service(value=DataType.class)
public class IntegerType
extends AbstractNumberType<Integer> {
    @Override
    public String getJavaType() {
        return "Integer";
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("int"));
    }

    @Override
    public SqlType getSqlType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.INTEGER;
    }

    @Override
    public Integer valueOf(String str) {
        return Integer.valueOf(StringHelper.parseString((String)str));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Integer object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 4);
        } else {
            statement.setInt(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Integer get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return resultSet.getInt(pos[0]);
    }
}

