/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tentackle.common.Binary;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;

@Service(value=DataType.class)
public class BinaryType
extends AbstractDataType<Binary<? extends Serializable>> {
    @Override
    public String getJavaType() {
        return "Binary";
    }

    @Override
    public boolean isJavaTypeGenerified() {
        return true;
    }

    @Override
    public SqlType getSqlType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.BLOB;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Binary<? extends Serializable> valueOf(String str) {
        throw new BackendException("cannot convert a String to a Binary");
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Binary<? extends Serializable> object, boolean mapNull, Integer size) throws SQLException {
        if (object == null || object.getLength() == 0) {
            object = null;
            statement.setNull(pos, -4);
        } else {
            statement.setBlob(pos, object.getInputStream(), object.getLength());
        }
        return new Object[]{object};
    }

    @Override
    public Binary<? extends Serializable> get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        try {
            return Binary.createBinary((InputStream)resultSet.getBinaryStream(pos[0]), (int)(size == null ? 0 : size), (boolean)true);
        }
        catch (IOException exception) {
            throw new SQLException("could not deserialize Binary", exception);
        }
    }
}

