/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.datatypes.AbstractDataType;

public abstract class AbstractDateTimeType<T>
extends AbstractDataType<T> {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MS_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.000";
    private static final DateFormat MS_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");

    @Override
    public boolean isDateOrTime() {
        return true;
    }

    protected java.sql.Date parseDate(String str) throws BackendException {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            try {
                return new java.sql.Date(DATE_FORMAT.parse(StringHelper.parseString((String)str)).getTime());
            }
            catch (ParseException e) {
                throw new BackendException("parsing date from '" + str + "' failed", e);
            }
        }
    }

    protected Time parseTime(String str) throws BackendException {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            try {
                return new Time(TIME_FORMAT.parse(StringHelper.parseString((String)str)).getTime());
            }
            catch (ParseException e) {
                throw new BackendException("parsing time from '" + str + "' failed", e);
            }
        }
    }

    protected Timestamp parseTimestamp(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).length() > 3 && str.charAt(str.length() - 4) == '.') {
            DateFormat dateFormat = MS_TIMESTAMP_FORMAT;
            synchronized (dateFormat) {
                try {
                    return new Timestamp(MS_TIMESTAMP_FORMAT.parse(str).getTime());
                }
                catch (ParseException e) {
                    throw new BackendException("parsing timestamp with ms from '" + str + "' failed", e);
                }
            }
        }
        DateFormat dateFormat = TIMESTAMP_FORMAT;
        synchronized (dateFormat) {
            try {
                return new Timestamp(TIMESTAMP_FORMAT.parse(str).getTime());
            }
            catch (ParseException e) {
                throw new BackendException("parsing timestamp from '" + str + "' failed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printDate(Date date) {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printTime(Date time) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return TIME_FORMAT.format(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printTimestamp(Date timestamp) {
        if (timestamp.getTime() % 1000L != 0L) {
            DateFormat dateFormat = MS_TIMESTAMP_FORMAT;
            synchronized (dateFormat) {
                return MS_TIMESTAMP_FORMAT.format(timestamp);
            }
        }
        DateFormat dateFormat = TIMESTAMP_FORMAT;
        synchronized (dateFormat) {
            return TIMESTAMP_FORMAT.format(timestamp);
        }
    }
}

