/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;

public abstract class AbstractDataType<T>
implements DataType<T> {
    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public String getVariant() {
        return "";
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Optional<String> getColumnSuffix(int index) {
        if (index < 0 || index >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException();
        }
        return index == 0 ? Optional.empty() : Optional.of("_" + (index + 1));
    }

    @Override
    public Optional<String> getCommentSuffix(int index) {
        Optional<String> columnSuffix = this.getColumnSuffix(index);
        if (columnSuffix.isPresent()) {
            String suffix = columnSuffix.get();
            if (suffix.length() > 1 && suffix.startsWith("_")) {
                suffix = suffix.substring(1);
            }
            return Optional.of(" (" + suffix + ")");
        }
        return Optional.empty();
    }

    @Override
    public int getSize(int index, Integer size) {
        return size == null ? 0 : size;
    }

    @Override
    public int getScale(int index, Integer scale) {
        return scale == null ? 0 : scale;
    }

    @Override
    public Object getColumnValue(int index, T value) {
        return value;
    }

    @Override
    public String getColumnGetter(int index) {
        if (this.getColumnCount() == 1) {
            return "";
        }
        throw new UnsupportedOperationException("getColumnGetter not yet implemented for datatype " + this);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public DataType<?> toNonPrimitive() {
        return this;
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.empty();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isDateOrTime() {
        return false;
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isMapNullSupported() {
        return false;
    }

    @Override
    public boolean isUTCSupported() {
        return false;
    }

    @Override
    public boolean isModelProvidingInnerType() {
        return this.isJavaTypeGenerified();
    }

    @Override
    public boolean isJavaTypeGenerified() {
        return false;
    }

    @Override
    public boolean isDowncastNecessary() {
        return false;
    }

    @Override
    public boolean isLiteralSupported() {
        return this.getColumnCount() == 1;
    }

    @Override
    public String toLiteral(String str) {
        if (!this.isNumeric() && !((String)str).isEmpty() && ((String)str).charAt(0) != '\'') {
            str = "'" + (String)str + "'";
        }
        return str;
    }

    @Override
    public String valueOfLiteralToCode(String str) {
        if (this.isLiteralSupported()) {
            return str;
        }
        if (((String)str).length() > 0 && ((String)str).charAt(0) != '\"') {
            str = "\"" + (String)str + "\"";
        }
        return this.isPredefined() ? this.getJavaType() : this.getDataTypeConstant() + ".valueOf(" + (String)str + ")";
    }

    @Override
    public String toString(T object) {
        return StringHelper.toParsableString((String)object.toString());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getJavaType());
        if (this.isJavaTypeGenerified()) {
            buf.append("<?>");
        }
        return buf.toString();
    }

    @Override
    public String getDataTypeConstant() {
        StringBuilder buf = new StringBuilder();
        buf.append("DT_").append(this.getJavaType().toUpperCase());
        if (!this.getVariant().isEmpty()) {
            buf.append('_').append(this.getVariant().toUpperCase());
        }
        return buf.toString();
    }

    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, T object, int index, boolean mapNull, Integer size) throws SQLException {
        if (this.getColumnCount() == 1) {
            return this.set(backend, statement, pos, object, mapNull, size);
        }
        throw new UnsupportedOperationException("not yet implemented for datatype " + this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataType that = (AbstractDataType)o;
        if (!this.getJavaType().equals(that.getJavaType())) {
            return false;
        }
        return this.getVariant().equals(that.getVariant());
    }

    public int hashCode() {
        int result = this.getJavaType().hashCode();
        result = 31 * result + this.getVariant().hashCode();
        return result;
    }
}

