/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.MigrationStrategy;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.backends.AbstractSql92Backend;
import org.tentackle.sql.metadata.ColumnMetaData;
import org.tentackle.sql.metadata.IndexColumnMetaData;
import org.tentackle.sql.metadata.IndexMetaData;
import org.tentackle.sql.metadata.PostgresColumnMetaData;
import org.tentackle.sql.metadata.PostgresIndexColumnMetaData;
import org.tentackle.sql.metadata.PostgresIndexMetaData;
import org.tentackle.sql.metadata.TableMetaData;

@Service(value=Backend.class)
public class Postgres
extends AbstractSql92Backend {
    public static final String DEFAULT_SCHEMA = "public";
    public static final String SQL_LIMIT = " LIMIT ";
    public static final String SQL_OFFSET = " OFFSET ";
    public static final String SQL_LIMIT_PAR = " LIMIT ?";
    public static final String SQL_OFFSET_PAR = " OFFSET ?";
    public static final String[] RESERVED_WORDS_PG = new String[]{"TEXT"};
    private static final String[] RESERVED_SCHEMAS = new String[]{"information_schema", "pg_catalog", "pg_temp_1", "pg_toast", "pg_toast_temp_1"};
    private static Set<String> reservedWords;

    @Override
    public synchronized Set<String> getReservedWords() {
        if (reservedWords == null) {
            reservedWords = new HashSet<String>(super.getReservedWords());
            reservedWords.addAll(Arrays.asList(RESERVED_WORDS_PG));
        }
        return reservedWords;
    }

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":postgresql");
    }

    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("select pg_backend_pid()");
            if (rs.next()) {
                String string2 = "PID-" + rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new TentackleRuntimeException("cannot determine backend id", (Throwable)ex);
        }
    }

    @Override
    public boolean isReleaseSavepointSupported() {
        return true;
    }

    @Override
    public boolean isReservedSchemaName(String name) {
        for (String reserved_schema : RESERVED_SCHEMAS) {
            if (!reserved_schema.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTransientTransactionException(SQLException ex) {
        return super.isTransientTransactionException(ex) || this.isExceptionStateMatching(ex, "40P01", "55P03");
    }

    @Override
    public boolean isClobSupported() {
        return false;
    }

    @Override
    public boolean isFilteredIndexSupported() {
        return true;
    }

    @Override
    public boolean isFunctionBasedIndexSupported() {
        return true;
    }

    @Override
    public boolean needTxForFetchsize() {
        return true;
    }

    @Override
    public boolean needAliasForSubselect() {
        return true;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        sqlBuilder.insert(0, "SELECT ");
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
        if (limit > 0) {
            sqlBuilder.append(SQL_LIMIT_PAR);
        }
        if (offset > 0) {
            sqlBuilder.append(SQL_OFFSET_PAR);
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        return 1;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        if (limit > 0) {
            stmt.setInt(index++, limit);
        }
        if (offset > 0) {
            stmt.setInt(index++, offset);
        }
        return index;
    }

    @Override
    public ColumnMetaData createColumnMetaData(TableMetaData tableMetaData) {
        return new PostgresColumnMetaData(tableMetaData);
    }

    @Override
    public IndexMetaData createIndexMetaData(TableMetaData tableMetaData) {
        return new PostgresIndexMetaData(tableMetaData);
    }

    @Override
    public IndexColumnMetaData createIndexColumnMetaData(IndexMetaData indexMetaData) {
        return new PostgresIndexColumnMetaData(indexMetaData);
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        if (sqlType == SqlType.DECIMAL) {
            return 999;
        }
        return super.getMaxSize(sqlType);
    }

    @Override
    public int getDefaultSize(SqlType sqlType) {
        if (sqlType == SqlType.VARCHAR) {
            return 0;
        }
        return super.getDefaultSize(sqlType);
    }

    @Override
    public String getDefaultSchema() {
        return DEFAULT_SCHEMA;
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        switch (jdbcType) {
            case -6: 
            case 5: {
                return new SqlType[]{SqlType.TINYINT, SqlType.SMALLINT};
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return new SqlType[]{SqlType.VARCHAR, SqlType.CLOB};
            }
        }
        return super.jdbcTypeToSqlType(jdbcType, size, scale);
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        switch (sqlType) {
            case BIT: {
                return "BOOL";
            }
            case TINYINT: 
            case SMALLINT: {
                return "INT2";
            }
            case INTEGER: {
                return "INT4";
            }
            case BIGINT: {
                return "INT8";
            }
            case FLOAT: {
                return "FLOAT4";
            }
            case DOUBLE: {
                return "FLOAT8";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case CHAR: {
                return "CHAR(1)";
            }
            case VARCHAR: {
                return size == 0 ? "TEXT" : "VARCHAR";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case BLOB: {
                return "BYTEA";
            }
            case CLOB: {
                return "TEXT";
            }
        }
        return super.sqlTypeToString(sqlType, size);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String sqlNextFromSequene(String name) {
        return "SELECT NEXTVAL('" + name + "')";
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " TYPE " + this.columnTypeNullDefaultToString(columnName, sqlType, size, scale, true, null) + ";\n";
    }

    @Override
    public String sqlAlterColumnNullConstraint(String tableName, String columnName, boolean nullable) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" ALTER COLUMN ");
        buf.append(columnName);
        if (nullable) {
            buf.append(" DROP");
        } else {
            buf.append(" SET");
        }
        buf.append(" NOT NULL;\n");
        return buf.toString();
    }

    @Override
    public String toInternalType(String sqlTypeName) {
        String typeName = sqlTypeName.toLowerCase();
        int ndx = typeName.indexOf(40);
        if (ndx >= 0) {
            typeName = typeName.substring(0, ndx);
        }
        return typeName;
    }

    @Override
    public boolean isArrayOperatorSupported(String operator) {
        return "ALL".equals(operator) || "ANY".equals(operator);
    }

    @Override
    public MigrationStrategy[] getMigrationStrategy(ColumnMetaData column, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        boolean scaleWarning;
        ArrayList<MigrationStrategy> strategies = new ArrayList<MigrationStrategy>();
        int maxSize = this.getMaxSize(sqlType);
        boolean nameChanged = !column.getColumnName().equalsIgnoreCase(columnName);
        boolean commentChanged = !Objects.equals(column.getComment(), comment);
        boolean defaultChanged = !this.isDefaultEqual(column, sqlType, defaultValue);
        boolean nullChanged = column.isNullable() != nullable;
        boolean typeChanged = !column.matchesSqlType(sqlType);
        boolean sizeChanged = size > column.getSize() || size == 0 && (sqlType == SqlType.VARCHAR || sqlType == SqlType.CLOB) && column.getSize() > 0 && column.getSize() != Integer.MAX_VALUE;
        boolean sizeWarning = maxSize != -1 && size != 0 && size < column.getSize();
        boolean scaleChanged = scale > column.getScale();
        boolean bl = scaleWarning = maxSize != -1 && scale < column.getScale();
        if (nameChanged) {
            strategies.add(MigrationStrategy.NAME);
        }
        if (typeChanged || sizeChanged || scaleChanged) {
            strategies.add(MigrationStrategy.TYPE);
        } else if (sizeWarning || scaleWarning) {
            strategies.add(MigrationStrategy.TYPE_WARNING);
        }
        if (nullChanged) {
            strategies.add(MigrationStrategy.NULL);
        }
        if (defaultChanged) {
            strategies.add(MigrationStrategy.DEFAULT);
        }
        if (commentChanged) {
            strategies.add(MigrationStrategy.COMMENT);
        }
        return strategies.toArray(new MigrationStrategy[0]);
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = (sql = super.extractWhereClause(sql, whereOffset)).lastIndexOf(SQL_LIMIT);
        if (ndx >= 0) {
            sql = sql.substring(0, ndx);
        }
        if ((ndx = sql.lastIndexOf(SQL_OFFSET)) >= 0) {
            sql = sql.substring(0, ndx);
        }
        return sql;
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }
}

