/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public final class ZonedDateTimeType
extends AbstractDateTimeType<ZonedDateTime> {
    public static final String GMT = "GMT";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss VV");
    private static final DateTimeFormatter MS_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");

    public static boolean isGMT(String zoneId) {
        return zoneId == null || zoneId.isBlank() || GMT.equals(zoneId) || "UTC".equals(zoneId);
    }

    public static Timestamp timestampOf(ZonedDateTime value) {
        return Timestamp.valueOf(value.toLocalDateTime());
    }

    public static String zoneOf(ZonedDateTime value) {
        return value.getZone().getId();
    }

    @Override
    public String getJavaType() {
        return "ZonedDateTime";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public Object getMappedNullValue(Backend backend, int index) {
        return switch (index) {
            case 0 -> DateHelper.MIN_TIMESTAMP;
            case 1 -> GMT;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public int getColumnCount(Backend backend) {
        return 2;
    }

    @Override
    public int[] getSortableColumns() {
        return null;
    }

    @Override
    public Optional<String> getCommentSuffix(Backend backend, int index) {
        return switch (index) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of(" (TZ)");
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnGetter(int index, String varName) {
        return switch (index) {
            case 0 -> "ZonedDateTimeType.timestampOf(" + varName + ")";
            case 1 -> "ZonedDateTimeType.zoneOf(" + varName + ")";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public String getColumnAlias(int index) {
        return switch (index) {
            case 0 -> "timestamp";
            case 1 -> "zone";
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public Object getColumnValue(Backend backend, int index, ZonedDateTime value) {
        if (value != null) {
            return switch (index) {
                case 0 -> ZonedDateTimeType.timestampOf(value);
                case 1 -> ZonedDateTimeType.zoneOf(value);
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return null;
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        return switch (index) {
            case 0 -> super.getSize(backend, index, size);
            case 1 -> 32;
            default -> throw new IndexOutOfBoundsException(index);
        };
    }

    @Override
    public int getScale(Backend backend, int index, Integer scale) {
        return 0;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        return switch (index) {
            case 0 -> SqlType.TIMESTAMP;
            case 1 -> SqlType.VARCHAR;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public ZonedDateTime valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(ZonedDateTime object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public String toLiteral(String str, Integer index) {
        if (!((String)str).isEmpty() && ((String)str).charAt(0) != '\'') {
            str = "'" + (String)str + "'";
        }
        return str;
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (index != null) {
            if ("null".equals(str)) {
                return str;
            }
            if (!str.isEmpty() && Character.isDigit(str.charAt(0))) {
                str = StringHelper.toDoubleQuotes((String)str);
            }
            return switch (index) {
                case 0 -> "Timestamp.valueOf(" + str + ")";
                case 1 -> str;
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        if (!str.isEmpty() && Character.isDigit(str.charAt(0))) {
            str = StringHelper.toDoubleQuotes((String)str);
        }
        return "ZonedDateTime.parse(" + str + ")";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, ZonedDateTime object, boolean mapNull, Integer size) throws SQLException {
        String zoneId;
        Timestamp timestamp;
        if (object == null) {
            if (!mapNull) {
                statement.setNull(pos, 93);
                statement.setNull(pos + 1, 12);
                return new Object[]{null, null};
            }
            timestamp = DateHelper.MIN_TIMESTAMP;
            zoneId = GMT;
        } else {
            timestamp = ZonedDateTimeType.timestampOf(object);
            zoneId = ZonedDateTimeType.zoneOf(object);
        }
        statement.setTimestamp(pos, timestamp);
        statement.setString(pos + 1, zoneId);
        return new Object[]{timestamp, zoneId};
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, ZonedDateTime object, int index, boolean mapNull, Integer size) throws SQLException {
        switch (index) {
            case 0: {
                Timestamp timestamp;
                if (object == null) {
                    if (!mapNull) {
                        statement.setNull(pos, 93);
                        return null;
                    }
                    timestamp = DateHelper.MIN_TIMESTAMP;
                } else {
                    timestamp = ZonedDateTimeType.timestampOf(object);
                }
                statement.setTimestamp(pos, timestamp);
                Object object2 = timestamp;
                return object2;
            }
            case 1: {
                String zoneId;
                if (object == null) {
                    if (!mapNull) {
                        statement.setNull(pos, 12);
                        return null;
                    }
                    zoneId = GMT;
                } else {
                    zoneId = ZonedDateTimeType.zoneOf(object);
                }
                statement.setString(pos, zoneId);
                Object object2 = zoneId;
                return object2;
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public ZonedDateTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(pos[0]);
        String zoneId = resultSet.getString(pos[1]);
        if (resultSet.wasNull() || mapNull && timestamp.getTime() == 0L && ZonedDateTimeType.isGMT(zoneId)) {
            return null;
        }
        return ZonedDateTime.of(timestamp.toLocalDateTime(), ZoneId.of(zoneId));
    }

    public ZonedDateTime parse(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).contains(".")) {
            try {
                return MS_TIMESTAMP_FORMATTER.parse((CharSequence)str, ZonedDateTime::from);
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing timestamp with ms from '" + str + "' failed", e);
            }
        }
        try {
            return TIMESTAMP_FORMATTER.parse((CharSequence)str, ZonedDateTime::from);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing timestamp from '" + str + "' failed", e);
        }
    }

    public String format(ZonedDateTime dateTime) {
        int nanos = dateTime.getNano();
        if (nanos != 0) {
            return MS_TIMESTAMP_FORMATTER.format(dateTime);
        }
        return TIMESTAMP_FORMATTER.format(dateTime);
    }
}

