/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Optional;
import org.tentackle.common.I18NText;
import org.tentackle.common.ParameterString;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;

@Service(value=DataType.class)
public class I18NTextType
extends AbstractDataType<I18NText> {
    @Override
    public String getJavaType() {
        return "I18NText";
    }

    @Override
    public boolean isPredefined() {
        return false;
    }

    @Override
    public boolean isColumnCountBackendSpecific() {
        return true;
    }

    @Override
    public boolean isLiteralSupported(Integer index) {
        return false;
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        return this.getDataTypeConstant() + ".valueOf(" + this.valueStringToCode(str) + ")";
    }

    @Override
    public int getColumnCount(Backend backend) {
        return backend.getMaxSize(SqlType.VARCHAR) <= 0 ? 1 : 2;
    }

    @Override
    public Optional<String> getCommentSuffix(Backend backend, int index) {
        if (this.getColumnCount(backend) == 2) {
            return switch (index) {
                case 0 -> Optional.empty();
                case 1 -> Optional.of(" (CLOB)");
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return Optional.empty();
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (this.getColumnCount(backend) == 2) {
            if (!backend.isClobSupported()) {
                throw new BackendException(backend + " does not support the SQL type CLOB");
            }
            return switch (index) {
                case 0 -> SqlType.VARCHAR;
                case 1 -> SqlType.CLOB;
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return SqlType.VARCHAR;
    }

    @Override
    public int getSize(Backend backend, int index, Integer size) {
        int maxSize = this.getMaxSize(backend, size);
        if (maxSize > 0) {
            return switch (index) {
                case 0 -> maxSize;
                case 1 -> 0;
                default -> throw new IndexOutOfBoundsException(index);
            };
        }
        return 0;
    }

    @Override
    public int getScale(Backend backend, int index, Integer scale) {
        return 0;
    }

    @Override
    public Object getColumnValue(Backend backend, int index, I18NText value) {
        return null;
    }

    @Override
    public String getColumnGetter(int index, String varName) {
        throw new BackendException("getColumnGetter not applicable for backend-specific datatype " + this);
    }

    @Override
    public String getColumnAlias(int index) {
        throw new BackendException("getColumnAlias not applicable for backend-specific datatype " + this);
    }

    @Override
    public I18NText valueOf(String str) {
        return I18NText.valueOf((String)str);
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, I18NText object, boolean mapNull, Integer size) throws SQLException {
        int maxSize = this.getMaxSize(backend, size);
        if (object == null) {
            statement.setNull(pos, 12);
            if (maxSize > 0) {
                statement.setNull(pos + 1, 2005);
                return new Object[]{null, null};
            }
            return new Object[]{null};
        }
        String s = object.toParameterString().toString();
        if (maxSize > 0) {
            if (s.length() > maxSize) {
                statement.setNull(pos, 12);
                Clob clob = statement.getConnection().createClob();
                clob.setString(1L, s);
                statement.setClob(pos + 1, clob);
                return new Object[]{null, clob};
            }
            statement.setString(pos, s);
            statement.setNull(pos + 1, 2005);
            return new Object[]{s, null};
        }
        statement.setString(pos, s);
        return new Object[]{s};
    }

    @Override
    public Object set(Backend backend, PreparedStatement statement, int pos, I18NText object, int index, boolean mapNull, Integer size) throws SQLException {
        throw new BackendException("method not applicable for backend-specific datatype " + this);
    }

    @Override
    public I18NText get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        String s = resultSet.getString(pos[0]);
        if (s == null && this.getColumnCount(backend) == 2) {
            Clob clob = resultSet.getClob(pos[1]);
            String string = s = resultSet.wasNull() ? null : clob.getSubString(1L, (int)clob.length());
        }
        if (s != null) {
            try {
                return new I18NText(new ParameterString(s));
            }
            catch (ParseException px) {
                throw new BackendException("malformed I18NText contents", px);
            }
        }
        return null;
    }

    protected int getMaxSize(Backend backend, Integer size) {
        int maxSize = backend.getMaxSize(SqlType.VARCHAR);
        if (maxSize > 0 && size != null) {
            maxSize = Math.min(maxSize, size);
        }
        return maxSize;
    }
}

