/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.BackendPreparedStatement;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.backends.AbstractSql92Backend;

@Service(value=Backend.class)
public class Informix
extends AbstractSql92Backend {
    public static final String SQL_NVL = "NVL";
    public static final String SQL_FIRST = "FIRST ";
    public static final String SQL_SKIP = "SKIP ";
    public static final String SQL_FIRST_PAR = "FIRST ? ";
    public static final String SQL_SKIP_PAR = "SKIP ? ";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":informix");
    }

    @Override
    public String getName() {
        return "Informix";
    }

    @Override
    public String getDriverClassName() {
        return "com.informix.jdbc.IfxDriver";
    }

    @Override
    public String getBackendId(Connection connection) {
        return null;
    }

    @Override
    public Connection createConnection(String url, String username, char[] password) throws SQLException {
        return DriverManager.getConnection(url + ";user=" + username + ";password=" + this.createPassword(password));
    }

    @Override
    public String getCoalesceKeyword() {
        return SQL_NVL;
    }

    @Override
    public void buildSelectSql(StringBuilder sqlBuilder, boolean writeLock, int limit, int offset) {
        boolean insertSelect = this.isLeadingSelectMissing(sqlBuilder);
        if (limit > 0) {
            sqlBuilder.insert(0, SQL_FIRST_PAR);
        }
        if (offset > 0) {
            sqlBuilder.insert(0, SQL_SKIP_PAR);
        }
        if (insertSelect) {
            sqlBuilder.insert(0, "SELECT ");
        }
        if (writeLock) {
            sqlBuilder.append(" FOR UPDATE");
        }
    }

    @Override
    public int setLeadingSelectParameters(BackendPreparedStatement stmt, int limit, int offset) {
        int index = 1;
        if (offset > 0) {
            stmt.setInt(index++, offset);
        }
        if (limit > 0) {
            stmt.setInt(index++, limit);
        }
        return index;
    }

    @Override
    public int setTrailingSelectParameters(BackendPreparedStatement stmt, int index, int limit, int offset) {
        return index;
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        return switch (sqlType) {
            case SqlType.DECIMAL -> 31;
            case SqlType.VARCHAR -> 255;
            default -> super.getMaxSize(sqlType);
        };
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        return switch (sqlType) {
            case SqlType.BIT -> "BOOLEAN";
            case SqlType.TINYINT, SqlType.SMALLINT -> "SMALLINT";
            case SqlType.INTEGER -> "INT";
            case SqlType.BIGINT -> "INT8";
            case SqlType.FLOAT -> "SMALLFLOAT";
            case SqlType.DOUBLE -> "FLOAT";
            case SqlType.DECIMAL -> "NUMBER";
            case SqlType.CHAR -> "CHAR(1)";
            case SqlType.VARCHAR -> "VARCHAR";
            case SqlType.DATE -> "DATE";
            case SqlType.TIME -> "DATETIME";
            case SqlType.TIMESTAMP -> "DATETIME YEAR TO SECOND";
            case SqlType.BLOB -> "BYTE";
            case SqlType.CLOB -> "CLOB";
            default -> super.sqlTypeToString(sqlType, size);
        };
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        SqlType[] sqlTypeArray;
        switch (jdbcType) {
            case -6: 
            case 5: {
                SqlType[] sqlTypeArray2 = new SqlType[2];
                sqlTypeArray2[0] = SqlType.TINYINT;
                sqlTypeArray = sqlTypeArray2;
                sqlTypeArray2[1] = SqlType.SMALLINT;
                break;
            }
            case 92: 
            case 93: {
                SqlType[] sqlTypeArray3 = new SqlType[2];
                sqlTypeArray3[0] = SqlType.TIME;
                sqlTypeArray = sqlTypeArray3;
                sqlTypeArray3[1] = SqlType.TIMESTAMP;
                break;
            }
            default: {
                sqlTypeArray = super.jdbcTypeToSqlType(jdbcType, size, scale);
            }
        }
        return sqlTypeArray;
    }

    @Override
    public boolean isSequenceSupported() {
        return true;
    }

    @Override
    public boolean isSchemaSupported() {
        return false;
    }

    @Override
    public String sqlCreateSequence(String name, Long start, Long increment) {
        return NonStandardCommons.sqlCreateSequence(name, start, increment);
    }

    @Override
    public String sqlNextFromSequence(String name) {
        return "SELECT " + name + ".NEXTVAL";
    }

    @Override
    public String sqlRenameColumn(String tableName, String oldColumnName, String newColumnName) {
        return "RENAME COLUMN " + tableName + "." + oldColumnName + " TO " + newColumnName + ";\n";
    }

    @Override
    public String sqlRenameIndex(String tableName, String oldIndexName, String newIndexName) {
        return "RENAME INDEX " + oldIndexName + " TO " + newIndexName + ";\n";
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlDropColumn(String tableName, String columnName) {
        return "ALTER TABLE " + tableName + " DROP (" + columnName + ");\n";
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " MODIFY (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnDefault(String tableName, String columnName, SqlType sqlType, Object defaultValue) {
        StringBuilder buf = new StringBuilder("ALTER TABLE ");
        buf.append(tableName);
        buf.append(" MODIFY (");
        buf.append(columnName);
        buf.append(" ");
        if (defaultValue == null) {
            buf.append("DROP DEFAULT");
        } else {
            buf.append("SET DEFAULT ");
            buf.append(this.valueToLiteral(sqlType, defaultValue));
        }
        buf.append(");\n");
        return buf.toString();
    }

    @Override
    protected String extractWhereClause(String sql, int whereOffset) {
        int ndx = sql.indexOf(SQL_FIRST);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with FIRST");
        }
        ndx = sql.indexOf(SQL_SKIP);
        if (ndx >= 0) {
            throw new BackendException("backend does not support merging selects with SKIP");
        }
        return super.extractWhereClause(sql, whereOffset);
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }
}

