/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.backends;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.NonStandardCommons;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.backends.AbstractSql2003Backend;

@Service(value=Backend.class)
public class Db2
extends AbstractSql2003Backend {
    private static final String STR_CONTINUATION = " \\";

    @Override
    public boolean isMatchingUrl(String url) {
        return url.contains(":db2");
    }

    @Override
    public String getName() {
        return "DB2";
    }

    @Override
    public String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public int getMaxSize(SqlType sqlType) {
        return switch (sqlType) {
            case SqlType.DECIMAL -> 31;
            case SqlType.VARCHAR -> 512;
            default -> super.getMaxSize(sqlType);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBackendId(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT application_id() AS appid FROM SYSIBM.SYSDUMMY1");
            if (rs.next()) {
                String string2 = rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException ex) {
            throw new BackendException("cannot determine backend id", ex);
        }
    }

    @Override
    public boolean isTransientTransactionException(SQLException ex) {
        return super.isTransientTransactionException(ex) || this.isExceptionStateMatching(ex, "57014") || this.isExceptionErrorCodeMatching(ex, -952);
    }

    @Override
    public boolean isFunctionBasedIndexSupported() {
        return true;
    }

    @Override
    public String sqlCreateTableIntro(String tableName, String comment) {
        return this.appendContinuationString(super.sqlCreateTableIntro(tableName, comment));
    }

    @Override
    public String sqlTypeToString(SqlType sqlType, int size) {
        return switch (sqlType) {
            case SqlType.BIT, SqlType.TINYINT, SqlType.SMALLINT -> "SMALLINT";
            case SqlType.INTEGER -> "INTEGER";
            case SqlType.BIGINT -> "BIGINT";
            case SqlType.FLOAT -> "REAL";
            case SqlType.DOUBLE -> "DOUBLE";
            case SqlType.DECIMAL -> "DECIMAL";
            case SqlType.CHAR -> "CHAR(1)";
            case SqlType.VARCHAR -> "VARCHAR";
            case SqlType.DATE, SqlType.TIME -> "DATE";
            case SqlType.TIMESTAMP -> "TIMESTAMP";
            case SqlType.BLOB -> "BLOB";
            case SqlType.CLOB -> "CLOB";
            default -> super.sqlTypeToString(sqlType, size);
        };
    }

    @Override
    public SqlType[] jdbcTypeToSqlType(int jdbcType, int size, int scale) {
        SqlType[] sqlTypeArray;
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: {
                SqlType[] sqlTypeArray2 = new SqlType[3];
                sqlTypeArray2[0] = SqlType.BIT;
                sqlTypeArray2[1] = SqlType.TINYINT;
                sqlTypeArray = sqlTypeArray2;
                sqlTypeArray2[2] = SqlType.SMALLINT;
                break;
            }
            case 91: 
            case 92: {
                SqlType[] sqlTypeArray3 = new SqlType[2];
                sqlTypeArray3[0] = SqlType.DATE;
                sqlTypeArray = sqlTypeArray3;
                sqlTypeArray3[1] = SqlType.TIME;
                break;
            }
            default: {
                sqlTypeArray = super.jdbcTypeToSqlType(jdbcType, size, scale);
            }
        }
        return sqlTypeArray;
    }

    @Override
    public String sqlCreateColumn(String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue, boolean primaryKey, boolean withTrailingComma) {
        return this.appendContinuationString(super.sqlCreateColumn(columnName, comment, sqlType, size, scale, nullable, defaultValue, primaryKey, withTrailingComma));
    }

    @Override
    public String sqlCreateTableComment(String tableName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnTable(this, tableName, comment);
    }

    @Override
    public String sqlCreateColumnComment(String tableName, String columnName, String comment) {
        return NonStandardCommons.sqlCreateCommentOnColumn(this, tableName, columnName, comment);
    }

    @Override
    public String sqlAddColumn(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ADD (" + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ");\n";
    }

    @Override
    public String sqlAlterColumnType(String tableName, String columnName, String comment, SqlType sqlType, int size, int scale, boolean nullable, Object defaultValue) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " DATA TYPE " + this.sqlCreateTableAttributeWithoutComment(columnName, sqlType, size, scale, nullable, defaultValue, false, false) + ";\n";
    }

    @Override
    public String sqlRenameIndex(String tableName, String oldIndexName, String newIndexName) {
        return "RENAME INDEX " + oldIndexName + " TO " + newIndexName + ";\n";
    }

    @Override
    protected boolean isDropIfExistsSupported() {
        return true;
    }

    private String appendContinuationString(String sql) {
        sql = ((String)sql).endsWith("\n") ? ((String)sql).substring(0, ((String)sql).length() - 1) + " \\\n" : (String)sql + STR_CONTINUATION;
        return sql;
    }
}

