/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql;

public record ScriptRunnerResult(String sql, int offset, String warnings, int columnCount, Object[] results) {
    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.sql).append(" ->");
        if (this.columnCount > 0) {
            int[] width = new int[this.columnCount];
            int r = 0;
            for (Object result : this.results) {
                int colWidth;
                int colNdx;
                if (result == null) {
                    result = "null";
                }
                if (width[colNdx = r++ % this.columnCount] >= (colWidth = result.toString().length())) continue;
                width[colNdx] = colWidth;
            }
            r = 0;
            for (Object result : this.results) {
                int colNdx;
                if ((colNdx = r++ % this.columnCount) == 0) {
                    buf.append('\n');
                }
                buf.append(String.format(" %-" + width[colNdx] + "s", result));
            }
        } else {
            for (Object result : this.results) {
                buf.append(' ').append(result);
            }
        }
        if (!this.warnings.isEmpty()) {
            buf.append("\nWarnings: ").append(this.warnings);
        }
        return buf.toString();
    }
}

