/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.metadata;

import java.sql.DatabaseMetaData;
import java.util.Locale;
import org.tentackle.sql.metadata.MetaDataUtilities;

public class DatabaseMetaDataTableHeader {
    private final DatabaseMetaData metaData;
    private final String catalog;
    private final String schema;
    private final String name;
    private final String type;
    private final String comment;

    public DatabaseMetaDataTableHeader(DatabaseMetaData metaData, String catalog, String schema, String name, String type, String comment) {
        this.metaData = metaData;
        this.catalog = catalog == null ? null : catalog.toLowerCase(Locale.ROOT);
        this.schema = schema == null ? null : schema.toLowerCase(Locale.ROOT);
        this.name = name.toLowerCase(Locale.ROOT);
        this.type = type == null ? null : type.toUpperCase(Locale.ROOT);
        this.comment = comment;
    }

    public boolean isUserTable() {
        return this.type == null || this.type.isEmpty() || "TABLE".equals(this.type);
    }

    public boolean isReserved() {
        return this.isUserTable() && MetaDataUtilities.getInstance().isReservedTable(this.name);
    }

    public DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.isUserTable()) {
            buf.append(this.type).append(' ');
        }
        if (this.schema != null && !this.schema.isEmpty()) {
            buf.append(this.schema).append('.');
        }
        buf.append(this.name);
        if (this.comment != null && !this.comment.isEmpty()) {
            buf.append(" (").append(this.comment).append(")");
        }
        return buf.toString();
    }
}

