/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public class TimestampType
extends AbstractDateTimeType<Timestamp> {
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String MS_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateTimeFormatter MS_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public boolean isTimezoneApplicable() {
        return true;
    }

    @Override
    public String getJavaType() {
        return "Timestamp";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public Timestamp getMappedNullValue(Backend backend, int index) {
        return DateHelper.MIN_TIMESTAMP;
    }

    @Override
    public boolean isUTCSupported() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIMESTAMP;
    }

    @Override
    public Timestamp valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(Timestamp object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Timestamp object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = DateHelper.MIN_TIMESTAMP;
        }
        if (object == null) {
            statement.setNull(pos, 93);
        } else {
            statement.setTimestamp(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Timestamp get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(pos[0]);
        if (timestamp == null || mapNull && timestamp.equals((Timestamp)DateHelper.MIN_TIMESTAMP)) {
            return null;
        }
        return org.tentackle.common.Timestamp.createFrozen((long)timestamp.getTime(), (int)timestamp.getNanos());
    }

    protected Timestamp parse(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).contains(".")) {
            try {
                return Timestamp.valueOf(MS_TIMESTAMP_FORMAT.parse((CharSequence)str, LocalDateTime::from));
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing timestamp with ms from '" + str + "' failed", e);
            }
        }
        try {
            return Timestamp.valueOf(TIMESTAMP_FORMAT.parse((CharSequence)str, LocalDateTime::from));
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing timestamp from '" + str + "' failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String format(Timestamp timestamp) {
        if (timestamp.getTime() % 1000L != 0L) {
            DateTimeFormatter dateTimeFormatter = MS_TIMESTAMP_FORMAT;
            synchronized (dateTimeFormatter) {
                return MS_TIMESTAMP_FORMAT.format(timestamp.toLocalDateTime());
            }
        }
        DateTimeFormatter dateTimeFormatter = TIMESTAMP_FORMAT;
        synchronized (dateTimeFormatter) {
            return TIMESTAMP_FORMAT.format(timestamp.toLocalDateTime());
        }
    }
}

