/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractNumberType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Service(value=DataType.class)
public class LongType
extends AbstractNumberType<Long> {
    @Override
    public String getJavaType() {
        return "Long";
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("long"));
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.BIGINT;
    }

    @Override
    public Long valueOf(String str) {
        return Long.valueOf(StringHelper.parseString((String)str));
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if (!str.isEmpty()) {
            if (str.charAt(0) == '\"') {
                return super.valueOfLiteralToCode(str, index);
            }
            if (Character.isDigit(str.charAt(str.length() - 1))) {
                return str + "L";
            }
        }
        return str;
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Long object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, -5);
        } else {
            statement.setLong(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Long get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return resultSet.getLong(pos[0]);
    }
}

