/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDateTimeType;

@Service(value=DataType.class)
public final class LocalDateTimeType
extends AbstractDateTimeType<LocalDateTime> {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter MS_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String getJavaType() {
        return "LocalDateTime";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public Timestamp getMappedNullValue(Backend backend, int index) {
        return DateHelper.MIN_TIMESTAMP;
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.TIMESTAMP;
    }

    @Override
    public LocalDateTime valueOf(String str) {
        return this.parse(str);
    }

    @Override
    public String toString(LocalDateTime object) {
        return StringHelper.toParsableString((String)this.format(object));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, LocalDateTime object, boolean mapNull, Integer size) throws SQLException {
        Timestamp value;
        if (object == null) {
            if (!mapNull) {
                statement.setNull(pos, 93);
                return new Object[]{null};
            }
            value = DateHelper.MIN_TIMESTAMP;
        } else {
            value = Timestamp.valueOf(object);
        }
        statement.setTimestamp(pos, value);
        return new Object[]{value};
    }

    @Override
    public LocalDateTime get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(pos[0]);
        if (timestamp == null || mapNull && timestamp.equals((Timestamp)DateHelper.MIN_TIMESTAMP)) {
            return null;
        }
        return timestamp.toLocalDateTime();
    }

    public LocalDateTime parse(String str) throws BackendException {
        if ((str = StringHelper.parseString((String)str)).contains(".")) {
            try {
                return LocalDateTime.parse(str, MS_TIMESTAMP_FORMATTER);
            }
            catch (DateTimeParseException e) {
                throw new BackendException("parsing timestamp with ms from '" + str + "' failed", e);
            }
        }
        try {
            return LocalDateTime.parse(str, TIMESTAMP_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new BackendException("parsing timestamp from '" + str + "' failed", e);
        }
    }

    public String format(LocalDateTime dateTime) {
        int nanos = dateTime.getNano();
        if (nanos != 0) {
            return MS_TIMESTAMP_FORMATTER.format(dateTime);
        }
        return TIMESTAMP_FORMATTER.format(dateTime);
    }
}

