/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tentackle.common.Service;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.StringType;

@Service(value=DataType.class)
public final class LargeStringType
extends StringType {
    @Override
    public String getVariant() {
        return "Large";
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.CLOB;
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, String object, boolean mapNull, Integer size) throws SQLException {
        if (backend.isClobSupported()) {
            if (object == null && mapNull) {
                object = backend.getEmptyString();
            }
            if (object != null) {
                Clob clob = statement.getConnection().createClob();
                clob.setString(1L, object);
                statement.setClob(pos, clob);
            } else {
                statement.setNull(pos, 2005);
            }
            return new Object[]{object};
        }
        return super.set(backend, statement, pos, object, mapNull, size);
    }

    @Override
    public String get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        if (backend.isClobSupported()) {
            String str;
            Clob clob = resultSet.getClob(pos[0]);
            String string = str = clob == null ? null : clob.getSubString(1L, (int)clob.length());
            if (mapNull && str != null && str.equals(backend.getEmptyString())) {
                return null;
            }
            return str;
        }
        return super.get(backend, resultSet, pos, mapNull, size);
    }
}

