/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Service(value=DataType.class)
public class CharacterType
extends AbstractDataType<Character> {
    @Override
    public String getJavaType() {
        return "Character";
    }

    @Override
    public boolean isMapNullSupported() {
        return true;
    }

    @Override
    public Character getMappedNullValue(Backend backend, int index) {
        return Character.valueOf(' ');
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("char"));
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.CHAR;
    }

    @Override
    public Character valueOf(String str) {
        String cstr = StringHelper.parseString((String)str);
        if (cstr.length() != 1) {
            throw new TentackleRuntimeException("character must be of length 1: " + cstr);
        }
        return Character.valueOf(cstr.charAt(0));
    }

    @Override
    public String valueOfLiteralToCode(String str, Integer index) {
        if ("'".equals(str)) {
            return "'\\''";
        }
        if ("\\".equals(str)) {
            return "'\\\\'";
        }
        if (str.isEmpty()) {
            return "0";
        }
        if (str.length() == 1 || str.length() == 2 && str.charAt(0) == '\\') {
            return "'" + str + "'";
        }
        return str;
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Character object, boolean mapNull, Integer size) throws SQLException {
        if (object == null && mapNull) {
            object = Character.valueOf(' ');
        }
        if (object == null) {
            statement.setNull(pos, 1);
        } else {
            statement.setString(pos, String.valueOf(object));
        }
        return new Object[]{object};
    }

    @Override
    public Character get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        char value;
        String val = resultSet.getString(pos[0]);
        char c = value = val == null || val.isEmpty() ? (char)'\u0000' : val.charAt(0);
        return resultSet.wasNull() ? null : (mapNull && value == ' ' ? null : Character.valueOf(value));
    }
}

