/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendException;
import org.tentackle.sql.DataType;
import org.tentackle.sql.DataTypeFactory;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractDataType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Service(value=DataType.class)
public class BooleanType
extends AbstractDataType<Boolean> {
    @Override
    public String getJavaType() {
        return "Boolean";
    }

    @Override
    public boolean isBool() {
        return true;
    }

    @Override
    public Optional<DataType<?>> toPrimitive() {
        return Optional.of(DataTypeFactory.getInstance().get("boolean"));
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.BIT;
    }

    @Override
    public Boolean valueOf(String str) {
        String bstr = StringHelper.parseString((String)str);
        return switch (bstr.toLowerCase(Locale.ROOT)) {
            case "true", "t", "1" -> Boolean.TRUE;
            case "false", "f", "0" -> Boolean.FALSE;
            default -> throw new BackendException("invalid boolean value: " + bstr);
        };
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, Boolean object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, -7);
        } else {
            statement.setBoolean(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public Boolean get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return resultSet.getBoolean(pos[0]);
    }
}

