/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.sql.datatypes;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.DataType;
import org.tentackle.sql.SqlType;
import org.tentackle.sql.datatypes.AbstractNumberType;

@Service(value=DataType.class)
public class BigDecimalType
extends AbstractNumberType<BigDecimal> {
    @Override
    public String getJavaType() {
        return "BigDecimal";
    }

    @Override
    public SqlType getSqlType(Backend backend, int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return SqlType.DECIMAL;
    }

    @Override
    public BigDecimal valueOf(String str) {
        return new BigDecimal(StringHelper.parseString((String)str));
    }

    @Override
    public Object[] set(Backend backend, PreparedStatement statement, int pos, BigDecimal object, boolean mapNull, Integer size) throws SQLException {
        if (object == null) {
            statement.setNull(pos, 3);
        } else {
            statement.setBigDecimal(pos, object);
        }
        return new Object[]{object};
    }

    @Override
    public BigDecimal get(Backend backend, ResultSet resultSet, int[] pos, boolean mapNull, Integer size) throws SQLException {
        return resultSet.getBigDecimal(pos[0]);
    }
}

